/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.map.MapProcessor;
import xaero.map.file.export.PNGExportResult;
import xaero.map.gui.ConfigSettingEntry;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.ISettingEntry;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.MySmallButton;
import xaero.map.settings.ModOptions;

public class ExportScreen
extends GuiSettings {
    private static final IFormattableTextComponent EXPORTING_MESSAGE = new TranslationTextComponent("gui.xaero_export_screen_exporting");
    private final MapProcessor mapProcessor;
    private PNGExportResult result;
    private int stage;
    private final MapTileSelection selection;
    public boolean fullExport;

    public ExportScreen(Screen backScreen, Screen escScreen, MapProcessor mapProcessor, MapTileSelection selection) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_export_screen"), backScreen, escScreen);
        this.mapProcessor = mapProcessor;
        this.selection = selection;
        this.entries = new ISettingEntry[]{new ConfigSettingEntry(ModOptions.FULL_EXPORT), new ConfigSettingEntry(ModOptions.MULTIPLE_IMAGES_EXPORT), new ConfigSettingEntry(ModOptions.NIGHT_EXPORT), new ConfigSettingEntry(ModOptions.EXPORT_HIGHLIGHTS), new ConfigSettingEntry(ModOptions.EXPORT_SCALE_DOWN_SQUARE)};
        this.canSearch = false;
        this.shouldAddBackButton = false;
    }

    @Override
    public void func_231160_c_() {
        if (this.stage > 0) {
            return;
        }
        super.func_231160_c_();
        this.func_230480_a_((Widget)new MySmallButton(this.field_230708_k_ / 2 - 155, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm", new Object[0]), b -> {
            this.stage = 1;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }));
        this.func_230480_a_((Widget)new MySmallButton(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel", new Object[0]), b -> this.goBack()));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.renderEscapeScreen(matrixStack, par1, par2, par3);
        super.func_230430_a_(matrixStack, par1, par2, par3);
        if (this.result != null) {
            ExportScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)this.result.getMessage(), (int)(this.field_230708_k_ / 2), (int)20, (int)-1);
        }
        if (this.stage > 0) {
            ExportScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)EXPORTING_MESSAGE, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 6 + 68), (int)-1);
            if (this.stage == 1) {
                this.stage = 2;
                return;
            }
        }
        if (this.stage != 2) {
            return;
        }
        if (this.mapProcessor.getMapSaveLoad().exportPNG(this, this.fullExport ? null : this.selection)) {
            this.stage = 3;
            this.result = null;
            for (IGuiEventListener c : this.func_231039_at__()) {
                if (!(c instanceof Button)) continue;
                ((Button)c).field_230693_o_ = false;
            }
            return;
        }
        this.stage = 0;
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    public void onExportDone(PNGExportResult result) {
        this.result = result;
        this.stage = 0;
    }

    public MapTileSelection getSelection() {
        return this.selection;
    }
}

