/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.settings.IteratableOption;
import net.minecraft.client.settings.SliderPercentageOption;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.ISettingEntry;
import xaero.map.settings.ModOptions;

public class ConfigSettingEntry
implements ISettingEntry {
    public static final Set<ModOptions> FILE_ONLY_ENABLE = new HashSet<ModOptions>(Lists.newArrayList((Object[])new ModOptions[]{ModOptions.MAP_TELEPORT_ALLOWED}));
    private ModOptions option;

    public ConfigSettingEntry(ModOptions option) {
        this.option = option;
    }

    @Override
    public Widget createWidget(GameSettings mcOptions, int x, int y, int w, boolean canEditIngameSettings) {
        Widget widget = this.option.getMcOption().func_216586_a(mcOptions, x, y, w);
        boolean bl = widget.field_230693_o_ = !this.option.isDisabledBecauseNotIngame() && !this.option.isDisabledBecauseMinimap();
        if (widget.field_230693_o_ && FILE_ONLY_ENABLE.contains(this.option) && !WorldMap.settings.getClientBooleanValue(this.option)) {
            widget.field_230693_o_ = false;
        }
        return widget;
    }

    @Override
    public String getStringForSearch(GameSettings mcOptions) {
        String tooltipPart;
        String mainText;
        AbstractOption mcOption = this.option.getMcOption();
        CursorBox optionTooltip = this.option.getTooltip();
        String string = mcOption instanceof IteratableOption ? ((IteratableOption)mcOption).func_238157_c_(mcOptions).getString() : (mainText = mcOption instanceof SliderPercentageOption ? ((SliderPercentageOption)mcOption).func_238334_c_(mcOptions).getString() : "");
        if (optionTooltip != null) {
            tooltipPart = " " + optionTooltip.getPlainText();
            if (optionTooltip.getFullCode() != null) {
                tooltipPart = tooltipPart + " " + optionTooltip.getFullCode().replace("gui.xaero", "");
            }
        } else {
            tooltipPart = "";
        }
        return mainText + " " + this.option.getEnumStringRaw().replace("gui.xaero", "") + tooltipPart;
    }

    public int hashCode() {
        return this.option.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ConfigSettingEntry && ((ConfigSettingEntry)obj).option == this.option;
    }
}

