/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import java.nio.file.Path;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import xaero.map.WorldMap;
import xaero.map.common.config.CommonConfig;
import xaero.map.message.basic.ClientboundRulesPacket;
import xaero.map.message.basic.HandshakePacket;
import xaero.map.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.map.server.MinecraftServerData;
import xaero.map.server.MineraftServerDataInitializer;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.server.level.LevelMapPropertiesIO;
import xaero.map.server.player.IServerPlayer;
import xaero.map.server.player.ServerPlayerData;

public class CommonEvents {
    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity oldPlayer = event.getOriginal();
        if (oldPlayer instanceof ServerPlayerEntity) {
            PlayerEntity newPlayer = event.getPlayer();
            ((IServerPlayer)newPlayer).setXaeroWorldMapPlayerData(ServerPlayerData.get((ServerPlayerEntity)oldPlayer));
        }
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        new MineraftServerDataInitializer().init(event.getServer());
    }

    @SubscribeEvent
    public void onServerStopped(FMLServerStoppedEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            WorldMap.messageHandler.sendToPlayer((ServerPlayerEntity)player, new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(ServerPlayerEntity player) {
        WorldMap.messageHandler.sendToPlayer(player, new HandshakePacket());
        CommonConfig config = WorldMap.commonConfig;
        WorldMap.messageHandler.sendToPlayer(player, new ClientboundRulesPacket(config.allowCaveModeOnServer, config.allowNetherCaveModeOnServer));
        Path propertiesPath = player.field_70170_p.func_73046_m().func_240776_a_(LevelMapPropertiesIO.FILE_NAME);
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.func_184102_h());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            WorldMap.messageHandler.sendToPlayer(player, properties);
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
            player.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("gui.xaero_wm_error_loading_properties"));
        }
    }
}

