/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.resources.IResource;
import net.minecraft.state.StateHolder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.BiomeGetter;
import xaero.map.biome.BlockTintProvider;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.exception.SilentException;
import xaero.map.gui.GuiMap;
import xaero.map.misc.CachedFunction;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class MapWriter {
    public static final int MAX_TRANSPARENCY_BLEND_DEPTH = 5;
    public static final String[] DEFAULT_RESOURCE = new String[]{"minecraft", ""};
    private int X;
    private int Z;
    private int playerChunkX;
    private int playerChunkZ;
    private int loadDistance;
    private int startTileChunkX;
    private int startTileChunkZ;
    private int endTileChunkX;
    private int endTileChunkZ;
    private int insideX;
    private int insideZ;
    private long updateCounter;
    private int caveStart;
    private int writingLayer = Integer.MAX_VALUE;
    private int writtenCaveStart = Integer.MAX_VALUE;
    private boolean clearCachedColours;
    private MapBlock loadingObject;
    private OverlayBuilder overlayBuilder;
    private final BlockPos.Mutable mutableLocalPos;
    private final BlockPos.Mutable mutableGlobalPos;
    private Random usedRandom = new Random(0L);
    private long lastWrite = -1L;
    private long lastWriteTry = -1L;
    private int workingFrameCount;
    private long framesFreedTime = -1L;
    public long writeFreeSinceLastWrite = -1L;
    private int writeFreeSizeTiles;
    private int writeFreeFullUpdateTargetTime;
    private MapProcessor mapProcessor;
    private ArrayList<BlockState> buggedStates;
    private BlockStateShortShapeCache blockStateShortShapeCache;
    private int topH;
    private final CachedFunction<StateHolder<?, ?>, Boolean> transparentCache;
    private int firstTransparentStateY;
    private final BlockPos.Mutable mutableBlockPos3;
    private CachedFunction<FluidState, BlockState> fluidToBlock;
    private BiomeGetter biomeGetter;
    private ArrayList<MapRegion> regionBuffer = new ArrayList();
    private MapTileChunk rightChunk = null;
    private MapTileChunk bottomRightChunk = null;
    private HashMap<String, Integer> textureColours;
    private HashMap<BlockState, Integer> blockColours;
    private long lastLayerSwitch;
    private BlockState lastBlockStateForTextureColor = null;
    private int lastBlockStateForTextureColorResult = -1;

    public MapWriter(OverlayManager overlayManager, BlockStateShortShapeCache blockStateShortShapeCache, BiomeGetter biomeGetter) {
        this.loadingObject = new MapBlock();
        this.textureColours = new HashMap();
        this.blockColours = new HashMap();
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.mutableLocalPos = new BlockPos.Mutable();
        this.mutableGlobalPos = new BlockPos.Mutable();
        this.buggedStates = new ArrayList();
        this.blockStateShortShapeCache = blockStateShortShapeCache;
        this.transparentCache = new CachedFunction<StateHolder, Boolean>(state -> this.shouldOverlay((StateHolder<?, ?>)state));
        this.mutableBlockPos3 = new BlockPos.Mutable();
        this.fluidToBlock = new CachedFunction<FluidState, BlockState>(FluidState::func_206883_i);
        this.biomeGetter = biomeGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender(BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager) {
        block41: {
            long before = System.nanoTime();
            try {
                if (WorldMap.crashHandler.getCrashedBy() != null) break block41;
                Object object = this.mapProcessor.renderThreadPauseSync;
                synchronized (object) {
                    if (!this.mapProcessor.isWritingPaused() && !this.mapProcessor.isWaitingForWorldUpdate() && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete() && this.mapProcessor.isCurrentMultiworldWritable()) {
                        if (this.mapProcessor.getWorld() == null || this.mapProcessor.isCurrentMapLocked()) {
                            return;
                        }
                        if (this.mapProcessor.getCurrentWorldId() != null && !this.mapProcessor.ignoreWorld((World)this.mapProcessor.getWorld()) && (WorldMap.settings.updateChunks || WorldMap.settings.loadChunks || !this.mapProcessor.getMapWorld().isMultiplayer())) {
                            Object blockTintProvider;
                            long passed;
                            double playerZ;
                            double playerY;
                            double playerX;
                            Object object2 = this.mapProcessor.mainStuffSync;
                            synchronized (object2) {
                                if (this.mapProcessor.mainWorld != this.mapProcessor.getWorld()) {
                                    return;
                                }
                                playerX = this.mapProcessor.mainPlayerX;
                                playerY = this.mapProcessor.mainPlayerY;
                                playerZ = this.mapProcessor.mainPlayerZ;
                            }
                            XaeroWorldMapCore.ensureField();
                            int lengthX = this.endTileChunkX - this.startTileChunkX + 1;
                            int lengthZ = this.endTileChunkZ - this.startTileChunkZ + 1;
                            if (this.lastWriteTry == -1L) {
                                lengthX = 3;
                                lengthZ = 3;
                            }
                            int sizeTileChunks = lengthX * lengthZ;
                            int sizeTiles = sizeTileChunks * 4 * 4;
                            int sizeBasedTargetTime = sizeTiles * 1000 / 1500;
                            int fullUpdateTargetTime = Math.max(100, sizeBasedTargetTime);
                            long time = System.currentTimeMillis();
                            long l = passed = this.lastWrite == -1L ? 0L : time - this.lastWrite;
                            if (this.lastWriteTry == -1L || this.writeFreeSizeTiles != sizeTiles || this.writeFreeFullUpdateTargetTime != fullUpdateTargetTime || this.workingFrameCount > 30) {
                                this.framesFreedTime = time;
                                this.writeFreeSizeTiles = sizeTiles;
                                this.writeFreeFullUpdateTargetTime = fullUpdateTargetTime;
                                this.workingFrameCount = 0;
                            }
                            long sinceLastWrite = Math.min(passed, this.writeFreeSinceLastWrite);
                            if (this.framesFreedTime != -1L) {
                                sinceLastWrite = time - this.framesFreedTime;
                            }
                            long tilesToUpdate = Math.min(sinceLastWrite * (long)sizeTiles / (long)fullUpdateTargetTime, 100L);
                            if (this.lastWrite == -1L || tilesToUpdate != 0L) {
                                this.lastWrite = time;
                            }
                            if (tilesToUpdate != 0L) {
                                if (this.framesFreedTime == -1L) {
                                    int timeLimit = (int)(Math.min(sinceLastWrite, 50L) * 86960L);
                                    long writeStartNano = System.nanoTime();
                                    MutableRegistry<Biome> biomeRegistry = this.mapProcessor.worldBiomeRegistry;
                                    boolean loadChunks = WorldMap.settings.loadChunks || !this.mapProcessor.getMapWorld().isMultiplayer();
                                    boolean updateChunks = WorldMap.settings.updateChunks || !this.mapProcessor.getMapWorld().isMultiplayer();
                                    boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
                                    boolean flowers = WorldMap.settings.flowers;
                                    boolean detailedDebug = WorldMap.settings.detailed_debug;
                                    int caveDepth = WorldMap.settings.caveModeDepth;
                                    BlockPos.Mutable mutableBlockPos3 = this.mutableBlockPos3;
                                    blockTintProvider = this.mapProcessor.getWorldBlockTintProvider();
                                    int i = 0;
                                    while ((long)i < tilesToUpdate) {
                                        if (this.writeMap((World)this.mapProcessor.getWorld(), playerX, playerY, playerZ, biomeRegistry, biomeColorCalculator, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, (BlockTintProvider)blockTintProvider, caveDepth)) {
                                            --i;
                                        }
                                        if (System.nanoTime() - writeStartNano >= (long)timeLimit) break;
                                        ++i;
                                    }
                                    ++this.workingFrameCount;
                                } else {
                                    this.writeFreeSinceLastWrite = sinceLastWrite;
                                    this.framesFreedTime = -1L;
                                }
                            }
                            this.lastWriteTry = time;
                            int startRegionX = this.startTileChunkX >> 3;
                            int startRegionZ = this.startTileChunkZ >> 3;
                            int endRegionX = this.endTileChunkX >> 3;
                            int endRegionZ = this.endTileChunkZ >> 3;
                            boolean shouldRequestLoading = false;
                            LeveledRegion<?> nextToLoad = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                            if (nextToLoad != null) {
                                LeveledRegion<?> ignoreHeightmaps = nextToLoad;
                                synchronized (ignoreHeightmaps) {
                                    if (!(nextToLoad.reloadHasBeenRequested() || nextToLoad.hasRemovableSourceData() || nextToLoad instanceof MapRegion && ((MapRegion)nextToLoad).isRefreshing())) {
                                        shouldRequestLoading = true;
                                    }
                                }
                            } else {
                                shouldRequestLoading = true;
                            }
                            this.regionBuffer.clear();
                            int comparisonChunkX = this.playerChunkX - 16;
                            int comparisonChunkZ = this.playerChunkZ - 16;
                            LeveledRegion.setComparison(comparisonChunkX, comparisonChunkZ, 0, comparisonChunkX, comparisonChunkZ);
                            for (int visitRegionX = startRegionX; visitRegionX <= endRegionX; ++visitRegionX) {
                                for (int visitRegionZ = startRegionZ; visitRegionZ <= endRegionZ; ++visitRegionZ) {
                                    MapRegion visitRegion = this.mapProcessor.getMapRegion(this.writingLayer, visitRegionX, visitRegionZ, true);
                                    if (visitRegion != null && visitRegion.getLoadState() == 2) {
                                        visitRegion.registerVisit();
                                    }
                                    blockTintProvider = visitRegion;
                                    synchronized (blockTintProvider) {
                                        if (visitRegion.isResting() && shouldRequestLoading && !visitRegion.reloadHasBeenRequested() && !visitRegion.recacheHasBeenRequested() && (visitRegion.getLoadState() == 0 || visitRegion.getLoadState() == 4)) {
                                            visitRegion.calculateSortingChunkDistance();
                                            Misc.addToListOfSmallest(10, this.regionBuffer, visitRegion);
                                        }
                                        continue;
                                    }
                                }
                            }
                            int toRequest = 1;
                            int counter = 0;
                            for (int i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                                MapRegion region = this.regionBuffer.get(i);
                                if (region == nextToLoad && this.regionBuffer.size() > 1) continue;
                                MapRegion mapRegion = region;
                                synchronized (mapRegion) {
                                    if (region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.getLoadState() != 0 && region.getLoadState() != 4) {
                                        continue;
                                    }
                                    region.setBeingWritten(true);
                                    this.mapProcessor.getMapSaveLoad().requestLoad(region, "writing");
                                    if (counter == 0) {
                                        this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing((LeveledRegion<?>)region);
                                    }
                                    ++counter;
                                    if (region.getLoadState() == 4) {
                                        break;
                                    }
                                    continue;
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
        }
    }

    public int getWriteDistance() {
        return Math.min(32, Minecraft.func_71410_x().field_71474_y.field_151451_c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMap(World world, double playerX, double playerY, double playerZ, MutableRegistry<Biome> biomeRegistry, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, BlockPos.Mutable mutableBlockPos3, BlockTintProvider blockTintProvider, int caveDepth) {
        boolean onlyLoad = loadChunks && (!updateChunks || this.updateCounter % 5L != 0L);
        World world2 = world;
        synchronized (world2) {
            if (this.insideX == 0 && this.insideZ == 0) {
                if (this.X == 0 && this.Z == 0) {
                    this.writtenCaveStart = this.caveStart;
                }
                this.mapProcessor.updateCaveStart();
                int newWritingLayer = this.mapProcessor.getCurrentCaveLayer();
                if (this.writingLayer != newWritingLayer && System.currentTimeMillis() - this.lastLayerSwitch > 300L) {
                    this.writingLayer = newWritingLayer;
                    this.lastLayerSwitch = System.currentTimeMillis();
                }
                this.loadDistance = this.getWriteDistance();
                if (this.writingLayer != Integer.MAX_VALUE && !(Minecraft.func_71410_x().field_71462_r instanceof GuiMap)) {
                    this.loadDistance = Math.min(16, this.loadDistance);
                }
                this.caveStart = this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().getLayer(this.writingLayer).getCaveStart();
                if (this.caveStart != this.writtenCaveStart) {
                    this.loadDistance = Math.min(4, this.loadDistance);
                }
                this.playerChunkX = (int)Math.floor(playerX) >> 4;
                this.playerChunkZ = (int)Math.floor(playerZ) >> 4;
                this.startTileChunkX = this.playerChunkX - this.loadDistance >> 2;
                this.startTileChunkZ = this.playerChunkZ - this.loadDistance >> 2;
                this.endTileChunkX = this.playerChunkX + this.loadDistance >> 2;
                this.endTileChunkZ = this.playerChunkZ + this.loadDistance >> 2;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl25 : MonitorExitStatement: MONITOREXIT : var20_17
            int tileChunkX = this.startTileChunkX + this.X;
            int tileChunkZ = this.startTileChunkZ + this.Z;
            int tileChunkLocalX = tileChunkX & 7;
            int tileChunkLocalZ = tileChunkZ & 7;
            int chunkX = tileChunkX * 4 + this.insideX;
            int chunkZ = tileChunkZ * 4 + this.insideZ;
            boolean wasSkipped = this.writeChunk(world, this.loadDistance, onlyLoad, biomeRegistry, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, blockTintProvider, caveDepth, this.caveStart, this.writingLayer, tileChunkX, tileChunkZ, tileChunkLocalX, tileChunkLocalZ, chunkX, chunkZ);
            return wasSkipped && (Math.abs(chunkX - this.playerChunkX) > 8 || Math.abs(chunkZ - this.playerChunkZ) > 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeChunk(World world, int distance, boolean onlyLoad, MutableRegistry<Biome> biomeRegistry, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, BlockPos.Mutable mutableBlockPos3, BlockTintProvider blockTintProvider, int caveDepth, int caveStart, int layerToWrite, int tileChunkX, int tileChunkZ, int tileChunkLocalX, int tileChunkLocalZ, int chunkX, int chunkZ) {
        int regionX = tileChunkX >> 3;
        int regionZ = tileChunkZ >> 3;
        MapTileChunk tileChunk = null;
        this.rightChunk = null;
        MapTileChunk bottomChunk = null;
        this.bottomRightChunk = null;
        MapRegion region = this.mapProcessor.getMapRegion(layerToWrite, regionX, regionZ, true);
        boolean wasSkipped = true;
        Object object = region.writerThreadPauseSync;
        synchronized (object) {
            if (!region.isWritingPaused()) {
                boolean regionIsResting;
                boolean isProperLoadState;
                boolean createdTileChunk = false;
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    boolean bl = isProperLoadState = region.getLoadState() == 2;
                    if (isProperLoadState) {
                        region.registerVisit();
                    }
                    if (regionIsResting = region.isResting()) {
                        region.setBeingWritten(true);
                        tileChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ);
                        if (isProperLoadState && tileChunk == null) {
                            tileChunk = new MapTileChunk(region, tileChunkX, tileChunkZ);
                            region.setChunk(tileChunkLocalX, tileChunkLocalZ, tileChunk);
                            tileChunk.setLoadState((byte)2);
                            region.setAllCachePrepared(false);
                            createdTileChunk = true;
                        }
                        if (!region.isMultiplayer()) {
                            region.getDim().getLayeredMapRegions().applyToEachLoadedLayer((i, layer) -> {
                                if (i.intValue() != region.getCaveLayer()) {
                                    MapRegion sameRegionAnotherLayer = this.mapProcessor.getMapRegion((int)i, regionX, regionZ, true);
                                    sameRegionAnotherLayer.setOutdatedWithOtherLayers(true);
                                    sameRegionAnotherLayer.setHasHadTerrain();
                                }
                            });
                        }
                    }
                }
                if (regionIsResting && isProperLoadState) {
                    if (tileChunk != null && tileChunk.getLoadState() == 2) {
                        if (!tileChunk.getLeafTexture().shouldUpload()) {
                            boolean cave = caveStart != Integer.MAX_VALUE;
                            boolean fullCave = caveStart == Integer.MIN_VALUE;
                            int lowH = 0;
                            if (cave && !fullCave && (lowH = caveStart + 1 - caveDepth) < 0) {
                                lowH = 0;
                            }
                            if (chunkX >= this.playerChunkX - distance && chunkX < this.playerChunkX + distance && chunkZ >= this.playerChunkZ - distance && chunkZ < this.playerChunkZ + distance) {
                                Chunk chunk = (Chunk)world.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, false);
                                MapTile mapTile = tileChunk.getTile(this.insideX, this.insideZ);
                                boolean chunkUpdated = false;
                                try {
                                    chunkUpdated = chunk != null && (mapTile == null || mapTile.getWrittenCaveStart() != caveStart || mapTile.getWrittenCaveDepth() != caveDepth || (Boolean)XaeroWorldMapCore.chunkCleanField.get(chunk) == false);
                                }
                                catch (IllegalAccessException | IllegalArgumentException e) {
                                    throw new RuntimeException(e);
                                }
                                if (chunkUpdated && !(chunk instanceof EmptyChunk)) {
                                    boolean edgeChunk = false;
                                    block8: for (int i2 = -1; i2 < 2; ++i2) {
                                        for (int j = -1; j < 2; ++j) {
                                            Chunk neighbor;
                                            if (i2 == 0 && j == 0 || (neighbor = world.func_212866_a_(chunkX + i2, chunkZ + j)) != null && !(neighbor instanceof EmptyChunk)) continue;
                                            edgeChunk = true;
                                            break block8;
                                        }
                                    }
                                    if (!edgeChunk && (mapTile == null && loadChunks || mapTile != null && updateChunks && (!onlyLoad || mapTile.getWrittenCaveStart() != caveStart || mapTile.getWrittenCaveDepth() != caveDepth))) {
                                        wasSkipped = false;
                                        if (mapTile == null) {
                                            mapTile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                                            tileChunk.setChanged(true);
                                        }
                                        MapTileChunk prevTileChunk = tileChunk.getNeighbourTileChunk(0, -1, this.mapProcessor, false);
                                        MapTileChunk prevTileChunkDiagonal = tileChunk.getNeighbourTileChunk(-1, -1, this.mapProcessor, false);
                                        MapTileChunk prevTileChunkHorisontal = tileChunk.getNeighbourTileChunk(-1, 0, this.mapProcessor, false);
                                        int sectionBasedHeight = this.getSectionBasedHeight(chunk, 64);
                                        Heightmap.Type typeWorldSurface = Heightmap.Type.WORLD_SURFACE;
                                        MapTile bottomTile = this.insideZ < 3 ? tileChunk.getTile(this.insideX, this.insideZ + 1) : null;
                                        MapTile rightTile = this.insideX < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ) : null;
                                        boolean triedFetchingBottomChunk = false;
                                        boolean triedFetchingRightChunk = false;
                                        for (int x = 0; x < 16; ++x) {
                                            for (int z = 0; z < 16; ++z) {
                                                boolean xEdge;
                                                int mappedHeight = chunk.func_201576_a(typeWorldSurface, x, z);
                                                int startHeight = cave && !fullCave ? caveStart : (ignoreHeightmaps || mappedHeight == -1 ? sectionBasedHeight : mappedHeight);
                                                MapBlock currentPixel = mapTile.isLoaded() ? mapTile.getBlock(x, z) : null;
                                                this.loadPixel(world, this.loadingObject, currentPixel, chunk, x, z, startHeight, lowH, cave, fullCave, mappedHeight, mapTile.wasWrittenOnce(), ignoreHeightmaps, biomeRegistry, flowers, mutableBlockPos3);
                                                this.loadingObject.fixHeightType(x, z, mapTile, tileChunk, prevTileChunk, prevTileChunkDiagonal, prevTileChunkHorisontal, this.loadingObject.getEffectiveHeight(this.blockStateShortShapeCache), true, this.blockStateShortShapeCache);
                                                boolean equalsSlopesExcluded = this.loadingObject.equalsSlopesExcluded(currentPixel);
                                                boolean fullyEqual = this.loadingObject.equals(currentPixel, equalsSlopesExcluded);
                                                if (fullyEqual) continue;
                                                MapBlock loadedBlock = this.loadingObject;
                                                mapTile.setBlock(x, z, loadedBlock);
                                                this.loadingObject = currentPixel != null ? currentPixel : new MapBlock();
                                                if (equalsSlopesExcluded) continue;
                                                tileChunk.setChanged(true);
                                                boolean zEdge = z == 15;
                                                boolean bl = xEdge = x == 15;
                                                if (!zEdge && !xEdge || currentPixel != null && currentPixel.getEffectiveHeight(this.blockStateShortShapeCache) == loadedBlock.getEffectiveHeight(this.blockStateShortShapeCache)) continue;
                                                if (zEdge) {
                                                    if (!triedFetchingBottomChunk && bottomTile == null && this.insideZ == 3 && tileChunkLocalZ < 7) {
                                                        bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                                                        triedFetchingBottomChunk = true;
                                                        MapTile mapTile2 = bottomTile = bottomChunk != null ? bottomChunk.getTile(this.insideX, 0) : null;
                                                        if (bottomTile != null) {
                                                            bottomChunk.setChanged(true);
                                                        }
                                                    }
                                                    if (bottomTile != null && bottomTile.isLoaded()) {
                                                        bottomTile.getBlock(x, 0).setSlopeUnknown(true);
                                                        if (!xEdge) {
                                                            bottomTile.getBlock(x + 1, 0).setSlopeUnknown(true);
                                                        }
                                                    }
                                                    if (!xEdge) continue;
                                                    this.updateBottomRightTile(region, tileChunk, bottomChunk, tileChunkLocalX, tileChunkLocalZ);
                                                    continue;
                                                }
                                                if (!xEdge) continue;
                                                if (!triedFetchingRightChunk && rightTile == null && this.insideX == 3 && tileChunkLocalX < 7) {
                                                    this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                                                    triedFetchingRightChunk = true;
                                                    MapTile mapTile3 = rightTile = this.rightChunk != null ? this.rightChunk.getTile(0, this.insideZ) : null;
                                                    if (rightTile != null) {
                                                        this.rightChunk.setChanged(true);
                                                    }
                                                }
                                                if (rightTile == null || !rightTile.isLoaded()) continue;
                                                rightTile.getBlock(0, z + 1).setSlopeUnknown(true);
                                            }
                                        }
                                        mapTile.setWorldInterpretationVersion(1);
                                        if (mapTile.getWrittenCaveStart() != caveStart) {
                                            tileChunk.setChanged(true);
                                        }
                                        mapTile.setWrittenCave(caveStart, caveDepth);
                                        tileChunk.setTile(this.insideX, this.insideZ, mapTile, this.blockStateShortShapeCache);
                                        mapTile.setWrittenOnce(true);
                                        mapTile.setLoaded(true);
                                        Misc.setReflectFieldValue(chunk, XaeroWorldMapCore.chunkCleanField, true);
                                    }
                                }
                            }
                        }
                        if (createdTileChunk) {
                            if (tileChunk.includeInSave()) {
                                tileChunk.setHasHadTerrain();
                            }
                            this.mapProcessor.getMapRegionHighlightsPreparer().prepare(region, tileChunkLocalX, tileChunkLocalZ, false);
                            if (!tileChunk.includeInSave() && !tileChunk.hasHighlightsIfUndiscovered()) {
                                region.setChunk(tileChunkLocalX, tileChunkLocalZ, null);
                                tileChunk = null;
                            }
                        }
                    }
                    if (tileChunk != null && this.insideX == 3 && this.insideZ == 3 && tileChunk.wasChanged()) {
                        tileChunk.updateBuffers(this.mapProcessor, blockTintProvider, overlayManager, detailedDebug, this.blockStateShortShapeCache);
                        if (bottomChunk == null && tileChunkLocalZ < 7) {
                            bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                        }
                        if (this.rightChunk == null && tileChunkLocalX < 7) {
                            this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                        }
                        if (this.bottomRightChunk == null && tileChunkLocalX < 7 && tileChunkLocalZ < 7) {
                            this.bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                        }
                        if (bottomChunk != null && bottomChunk.wasChanged()) {
                            bottomChunk.updateBuffers(this.mapProcessor, blockTintProvider, overlayManager, detailedDebug, this.blockStateShortShapeCache);
                            bottomChunk.setChanged(false);
                        }
                        if (this.rightChunk != null && this.rightChunk.wasChanged()) {
                            this.rightChunk.setToUpdateBuffers(true);
                            this.rightChunk.setChanged(false);
                        }
                        if (this.bottomRightChunk != null && this.bottomRightChunk.wasChanged()) {
                            this.bottomRightChunk.setToUpdateBuffers(true);
                            this.bottomRightChunk.setChanged(false);
                        }
                        tileChunk.setChanged(false);
                    }
                }
            } else {
                this.insideX = 3;
                this.insideZ = 3;
            }
        }
        ++this.insideZ;
        if (this.insideZ > 3) {
            this.insideZ = 0;
            ++this.insideX;
            if (this.insideX > 3) {
                this.insideX = 0;
                ++this.Z;
                if (this.Z > this.endTileChunkZ - this.startTileChunkZ) {
                    this.Z = 0;
                    ++this.X;
                    if (this.X > this.endTileChunkX - this.startTileChunkX) {
                        this.X = 0;
                        ++this.updateCounter;
                    }
                }
            }
        }
        return wasSkipped;
    }

    public void updateBottomRightTile(MapRegion region, MapTileChunk tileChunk, MapTileChunk bottomChunk, int tileChunkLocalX, int tileChunkLocalZ) {
        MapTile bottomRightTile;
        MapTile mapTile = bottomRightTile = this.insideX < 3 && this.insideZ < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ + 1) : null;
        if (bottomRightTile == null) {
            if (this.insideX == 3 && tileChunkLocalX < 7) {
                if (this.insideZ == 3) {
                    if (tileChunkLocalZ < 7) {
                        this.bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                    }
                    MapTile mapTile2 = bottomRightTile = this.bottomRightChunk != null ? this.bottomRightChunk.getTile(0, 0) : null;
                    if (bottomRightTile != null) {
                        this.bottomRightChunk.setChanged(true);
                    }
                } else {
                    if (this.rightChunk == null) {
                        this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                    }
                    MapTile mapTile3 = bottomRightTile = this.rightChunk != null ? this.rightChunk.getTile(0, this.insideZ + 1) : null;
                    if (bottomRightTile != null) {
                        this.rightChunk.setChanged(true);
                    }
                }
            } else if (this.insideX != 3 && this.insideZ == 3 && tileChunkLocalZ < 7) {
                MapTile mapTile4 = bottomRightTile = bottomChunk != null ? bottomChunk.getTile(this.insideX + 1, 0) : null;
                if (bottomRightTile != null) {
                    bottomChunk.setChanged(true);
                }
            }
        }
        if (bottomRightTile != null && bottomRightTile.isLoaded()) {
            bottomRightTile.getBlock(0, 0).setSlopeUnknown(true);
        }
    }

    public int getSectionBasedHeight(Chunk bchunk, int startY) {
        ChunkSection searchedSection;
        int i;
        ChunkSection[] sections = bchunk.func_76587_i();
        int playerSection = startY >> 4;
        int result = -1;
        for (i = playerSection; i < sections.length; ++i) {
            searchedSection = sections[i];
            if (searchedSection == Chunk.field_186036_a) continue;
            result = (i << 4) + 15;
        }
        if (playerSection > 0 && result == -1) {
            for (i = playerSection - 1; i >= 0; --i) {
                searchedSection = sections[i];
                if (searchedSection == Chunk.field_186036_a) continue;
                result = (i << 4) + 15;
                break;
            }
        }
        return result;
    }

    public boolean isGlowing(BlockState state) {
        return (double)state.func_185906_d() >= 0.5;
    }

    private boolean shouldOverlayCached(StateHolder<?, ?> state) {
        return this.transparentCache.apply(state);
    }

    public boolean shouldOverlay(StateHolder<?, ?> state) {
        if (state instanceof BlockState) {
            BlockState blockState = (BlockState)state;
            return blockState.func_177230_c() instanceof AirBlock || blockState.func_177230_c() instanceof GlassBlock || RenderTypeLookup.canRenderInLayer((BlockState)blockState, (RenderType)RenderType.func_228645_f_());
        }
        FluidState fluidState = (FluidState)state;
        return RenderTypeLookup.canRenderInLayer((FluidState)fluidState, (RenderType)RenderType.func_228645_f_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvisible(World world, BlockState state, Block b, boolean flowers) {
        boolean isFlower;
        if (!(b instanceof FlowingFluidBlock) && state.func_185901_i() == BlockRenderType.INVISIBLE) {
            return true;
        }
        if (b == Blocks.field_150478_aa) {
            return true;
        }
        if (b == Blocks.field_150349_c) {
            return true;
        }
        if (b == Blocks.field_150359_w || b == Blocks.field_150410_aZ) {
            return true;
        }
        boolean bl = isFlower = b instanceof TallFlowerBlock || b instanceof FlowerBlock || b instanceof BushBlock && state.func_235714_a_((ITag)BlockTags.field_226149_I_);
        if (b instanceof DoublePlantBlock && !isFlower) {
            return true;
        }
        if (isFlower && !flowers) {
            return true;
        }
        ArrayList<BlockState> arrayList = this.buggedStates;
        synchronized (arrayList) {
            if (this.buggedStates.contains(state)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasVanillaColor(BlockState state, World world, BlockPos pos) {
        MaterialColor materialColor = null;
        try {
            materialColor = state.func_185909_g((IBlockReader)world, pos);
        }
        catch (Throwable t) {
            ArrayList<BlockState> arrayList = this.buggedStates;
            synchronized (arrayList) {
                this.buggedStates.add(state);
            }
            WorldMap.LOGGER.info("Broken vanilla map color definition found: " + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)state.func_177230_c()));
        }
        return materialColor != null && materialColor.field_76291_p != 0;
    }

    private BlockState unpackFramedBlocks(BlockState original, World world, BlockPos globalPos) {
        TileEntity tileEntity;
        if (original.func_177230_c() instanceof AirBlock) {
            return original;
        }
        BlockState result = original;
        if (SupportMods.framedBlocks() && SupportMods.supportFramedBlocks.isFrameBlock(world, null, original) && (tileEntity = world.func_175625_s(globalPos)) != null && ((result = SupportMods.supportFramedBlocks.unpackFramedBlock(world, null, original, tileEntity)) == null || result.func_177230_c() instanceof AirBlock)) {
            result = original;
        }
        return result;
    }

    public void loadPixel(World world, MapBlock pixel, MapBlock currentPixel, Chunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean fullCave, int mappedHeight, boolean canReuseBiomeColours, boolean ignoreHeightmaps, MutableRegistry<Biome> biomeRegistry, boolean flowers, BlockPos.Mutable mutableBlockPos3) {
        pixel.prepareForWriting();
        this.overlayBuilder.startBuilding();
        boolean underair = !cave || fullCave;
        boolean shouldEnterGround = fullCave;
        BlockState opaqueState = null;
        byte workingLight = -1;
        boolean worldHasSkyLight = world.func_230315_m_().func_218272_d();
        byte workingSkyLight = worldHasSkyLight ? (byte)15 : 0;
        this.topH = lowY;
        this.mutableGlobalPos.func_181079_c((bchunk.func_76632_l().field_77276_a << 4) + insideX, lowY - 1, (bchunk.func_76632_l().field_77275_b << 4) + insideZ);
        boolean shouldExtendTillTheBottom = false;
        int transparentSkipY = 0;
        int h = highY;
        while (h >= lowY) {
            Block b;
            this.mutableLocalPos.func_181079_c(insideX, h, insideZ);
            BlockState state = bchunk.func_180495_p((BlockPos)this.mutableLocalPos);
            if (state == null) {
                state = Blocks.field_150350_a.func_176223_P();
            }
            this.mutableGlobalPos.func_185336_p(h);
            state = this.unpackFramedBlocks(state, world, (BlockPos)this.mutableGlobalPos);
            FluidState fluidFluidState = state.func_204520_s();
            boolean bl = shouldExtendTillTheBottom = !shouldExtendTillTheBottom && !this.overlayBuilder.isEmpty() && this.firstTransparentStateY - h >= 5;
            if (shouldExtendTillTheBottom) {
                for (transparentSkipY = h - 1; transparentSkipY >= lowY; --transparentSkipY) {
                    FluidState traceFluidState;
                    BlockState traceState = bchunk.func_180495_p((BlockPos)mutableBlockPos3.func_181079_c(insideX, transparentSkipY, insideZ));
                    if (traceState == null) {
                        traceState = Blocks.field_150350_a.func_176223_P();
                    }
                    if (!(traceFluidState = traceState.func_204520_s()).func_206888_e()) {
                        if (!this.shouldOverlayCached((StateHolder<?, ?>)traceFluidState)) break;
                        if (!(traceState.func_177230_c() instanceof AirBlock) && traceState.func_177230_c() == this.fluidToBlock.apply(traceFluidState).func_177230_c()) continue;
                    }
                    if (!this.shouldOverlayCached((StateHolder<?, ?>)traceState)) break;
                }
            }
            this.mutableGlobalPos.func_185336_p(h + 1);
            workingLight = (byte)world.func_226658_a_(LightType.BLOCK, (BlockPos)this.mutableGlobalPos);
            if (cave && workingLight < 15 && worldHasSkyLight) {
                workingSkyLight = !ignoreHeightmaps && !fullCave && highY >= mappedHeight ? (byte)15 : (byte)((byte)world.func_226658_a_(LightType.SKY, (BlockPos)this.mutableGlobalPos));
            }
            this.mutableGlobalPos.func_185336_p(h);
            if (!(fluidFluidState.func_206888_e() || cave && shouldEnterGround)) {
                underair = true;
                BlockState fluidState = this.fluidToBlock.apply(fluidFluidState);
                if (this.loadPixelHelp(pixel, currentPixel, world, fluidState, workingLight, workingSkyLight, bchunk, insideX, insideZ, h, canReuseBiomeColours, cave, fluidFluidState, biomeRegistry, transparentSkipY, shouldExtendTillTheBottom, flowers, underair)) {
                    opaqueState = state;
                    break;
                }
            }
            if ((b = state.func_177230_c()) instanceof AirBlock) {
                underair = true;
            } else if (underair && state.func_177230_c() != this.fluidToBlock.apply(fluidFluidState).func_177230_c()) {
                if (cave && shouldEnterGround) {
                    if (!(state.func_185904_a().func_76217_h() || state.func_185904_a().func_76222_j() || state.func_185904_a().func_186274_m() == PushReaction.DESTROY || this.shouldOverlayCached((StateHolder<?, ?>)state))) {
                        underair = false;
                        shouldEnterGround = false;
                    }
                } else if (this.loadPixelHelp(pixel, currentPixel, world, state, workingLight, workingSkyLight, bchunk, insideX, insideZ, h, canReuseBiomeColours, cave, null, biomeRegistry, transparentSkipY, shouldExtendTillTheBottom, flowers, underair)) {
                    opaqueState = state;
                    break;
                }
            }
            h = shouldExtendTillTheBottom ? transparentSkipY : h - 1;
        }
        if (h < lowY) {
            h = lowY;
        }
        RegistryKey<Biome> blockBiome = null;
        BlockState state = opaqueState == null ? Blocks.field_150350_a.func_176223_P() : opaqueState;
        this.overlayBuilder.finishBuilding(pixel);
        byte light = 0;
        if (opaqueState != null) {
            light = workingLight;
            if (cave && light < 15 && pixel.getNumberOfOverlays() == 0 && workingSkyLight > light) {
                light = workingSkyLight;
            }
        } else {
            h = 0;
        }
        if (!canReuseBiomeColours || currentPixel == null || currentPixel.getState() != state || currentPixel.getTopHeight() != this.topH) {
            this.mutableGlobalPos.func_185336_p(this.topH);
            blockBiome = this.biomeGetter.getBiome(world, (BlockPos)this.mutableGlobalPos, biomeRegistry);
            this.mutableGlobalPos.func_185336_p(h);
        } else {
            blockBiome = currentPixel.getBiome();
        }
        if (this.overlayBuilder.getOverlayBiome() != null) {
            blockBiome = this.overlayBuilder.getOverlayBiome();
        }
        boolean glowing = this.isGlowing(state);
        pixel.write(state, h, this.topH, blockBiome, light, glowing, cave);
    }

    private boolean loadPixelHelp(MapBlock pixel, MapBlock currentPixel, World world, BlockState state, byte light, byte skyLight, Chunk bchunk, int insideX, int insideZ, int h, boolean canReuseBiomeColours, boolean cave, FluidState fluidFluidState, MutableRegistry<Biome> biomeRegistry, int transparentSkipY, boolean shouldExtendTillTheBottom, boolean flowers, boolean underair) {
        Block b = state.func_177230_c();
        if (this.isInvisible(world, state, b, flowers)) {
            return false;
        }
        if (this.shouldOverlayCached((StateHolder<?, ?>)(fluidFluidState == null ? state : fluidFluidState))) {
            if (cave && !underair) {
                return false;
            }
            if (h > this.topH) {
                this.topH = h;
            }
            byte overlayLight = light;
            if (this.overlayBuilder.isEmpty()) {
                this.firstTransparentStateY = h;
                if (cave && skyLight > overlayLight) {
                    overlayLight = skyLight;
                }
            }
            if (shouldExtendTillTheBottom) {
                this.overlayBuilder.getCurrentOverlay().increaseOpacity(this.overlayBuilder.getCurrentOverlay().getState().func_200016_a((IBlockReader)world, (BlockPos)this.mutableGlobalPos) * (h - transparentSkipY));
            } else {
                RegistryKey<Biome> overlayBiome = this.overlayBuilder.getOverlayBiome();
                if (overlayBiome == null) {
                    overlayBiome = canReuseBiomeColours && currentPixel != null && currentPixel.getNumberOfOverlays() > 0 && currentPixel.getOverlays().get(0).getState() == state ? currentPixel.getBiome() : this.biomeGetter.getBiome(world, (BlockPos)this.mutableGlobalPos, biomeRegistry);
                }
                this.overlayBuilder.build(state, state.func_200016_a((IBlockReader)world, (BlockPos)this.mutableGlobalPos), overlayLight, this.mapProcessor, overlayBiome);
            }
            return false;
        }
        if (!this.hasVanillaColor(state, world, (BlockPos)this.mutableGlobalPos)) {
            return false;
        }
        if (cave && !underair) {
            return true;
        }
        if (h > this.topH) {
            this.topH = h;
        }
        return true;
    }

    public int loadBlockColourFromTexture(BlockState state, boolean convert, World world, BlockPos globalPos) {
        if (this.clearCachedColours) {
            this.textureColours.clear();
            this.blockColours.clear();
            this.lastBlockStateForTextureColor = null;
            this.lastBlockStateForTextureColorResult = -1;
            this.clearCachedColours = false;
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Xaero's World Map cache cleared!");
            }
        }
        if (state == this.lastBlockStateForTextureColor) {
            return this.lastBlockStateForTextureColorResult;
        }
        Integer c = this.blockColours.get(state);
        int red = 0;
        int green = 0;
        int blue = 0;
        int alpha = 0;
        Block b = state.func_177230_c();
        if (c == null) {
            String name = null;
            try {
                Integer cachedColour;
                List upQuads = null;
                BlockModelShapes bms = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
                IBakedModel model = bms.func_178125_b(state);
                if (convert) {
                    upQuads = model.getQuads(state, Direction.UP, this.usedRandom, (IModelData)EmptyModelData.INSTANCE);
                }
                TextureAtlasSprite missingTexture = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).func_195424_a(null);
                TextureAtlasSprite texture = upQuads == null || upQuads.isEmpty() || ((BakedQuad)upQuads.get(0)).func_187508_a() == missingTexture ? model.getParticleTexture((IModelData)EmptyModelData.INSTANCE) : ((BakedQuad)upQuads.get(0)).func_187508_a();
                if (texture == null) {
                    throw new SilentException("No texture for " + state);
                }
                name = texture.func_195668_m() + ".png";
                if (b instanceof OreBlock && b != Blocks.field_196766_fg) {
                    name = "minecraft:block/stone.png";
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    MapWriter.DEFAULT_RESOURCE[1] = args[0];
                    args = DEFAULT_RESOURCE;
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(location);
                    if (resource == null) {
                        throw new SilentException("No texture " + location);
                    }
                    InputStream input = resource.func_199027_b();
                    BufferedImage img = ImageIO.read(input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 0;
                    int ts = Math.min(img.getWidth(), img.getHeight());
                    if (ts > 0) {
                        int diff = Math.max(1, Math.min(4, ts / 8));
                        int parts = ts / diff;
                        Raster raster = img.getData();
                        int[] colorHolder = null;
                        for (int i = 0; i < parts; ++i) {
                            for (int j = 0; j < parts; ++j) {
                                int rgb;
                                if (img.getColorModel().getNumComponents() < 3) {
                                    colorHolder = raster.getPixel(i * diff, j * diff, colorHolder);
                                    int sample = colorHolder[0] & 0xFF;
                                    int a = 255;
                                    if (colorHolder.length > 1) {
                                        a = colorHolder[1];
                                    }
                                    rgb = a << 24 | sample << 16 | sample << 8 | sample;
                                } else {
                                    rgb = img.getRGB(i * diff, j * diff);
                                }
                                int a = rgb >> 24 & 0xFF;
                                if (rgb == 0 || a == 0) continue;
                                red += rgb >> 16 & 0xFF;
                                green += rgb >> 8 & 0xFF;
                                blue += rgb & 0xFF;
                                alpha += a;
                                ++total;
                            }
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    alpha /= total;
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new SilentException("Black texture " + ts);
                    }
                    c = alpha << 24 | red << 16 | green << 8 | blue;
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(state, false, world, globalPos);
                }
                WorldMap.LOGGER.info("Block file not found: " + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b));
                c = 0;
                if (state != null && state.func_185909_g((IBlockReader)world, globalPos) != null) {
                    c = state.func_185909_g((IBlockReader)world, (BlockPos)globalPos).field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.info("Exception when loading " + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b) + " texture, using material colour.");
                c = 0;
                if (state.func_185909_g((IBlockReader)world, globalPos) != null) {
                    c = state.func_185909_g((IBlockReader)world, (BlockPos)globalPos).field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                if (e instanceof SilentException) {
                    WorldMap.LOGGER.info(e.getMessage());
                }
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
            if (c != null) {
                this.blockColours.put(state, c);
            }
        }
        this.lastBlockStateForTextureColor = state;
        this.lastBlockStateForTextureColorResult = c;
        return c;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void resetPosition() {
        this.X = 0;
        this.Z = 0;
        this.insideX = 0;
        this.insideZ = 0;
    }

    public void requestCachedColoursClear() {
        this.clearCachedColours = true;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    public void setDirtyInWriteDistance(PlayerEntity player, World level) {
        int writeDistance = this.getWriteDistance();
        int playerChunkX = player.func_233580_cy_().func_177958_n() >> 4;
        int playerChunkZ = player.func_233580_cy_().func_177952_p() >> 4;
        int startChunkX = playerChunkX - writeDistance;
        int startChunkZ = playerChunkZ - writeDistance;
        int endChunkX = playerChunkX + writeDistance;
        int endChunkZ = playerChunkZ + writeDistance;
        for (int x = startChunkX; x < endChunkX; ++x) {
            for (int z = startChunkZ; z < endChunkZ; ++z) {
                Chunk chunk = level.func_212866_a_(x, z);
                if (chunk == null) continue;
                try {
                    XaeroWorldMapCore.chunkCleanField.set(chunk, false);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

