/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.IScreenRenderable;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PonderTag
implements IScreenRenderable {
    public static final PonderTag KINETIC_RELAYS = PonderTag.create("kinetic_relays").item((IItemProvider)AllBlocks.COGWHEEL.get(), true, false).defaultLang("Kinetic Blocks", "Components which help relaying Rotational Force elsewhere").addToIndex();
    public static final PonderTag KINETIC_SOURCES = PonderTag.create("kinetic_sources").item((IItemProvider)AllBlocks.WATER_WHEEL.get(), true, false).defaultLang("Kinetic Sources", "Components which generate Rotational Force").addToIndex();
    public static final PonderTag KINETIC_APPLIANCES = PonderTag.create("kinetic_appliances").item((IItemProvider)AllBlocks.MECHANICAL_PRESS.get(), true, false).defaultLang("Kinetic Appliances", "Components which make use of Rotational Force").addToIndex();
    public static final PonderTag FLUIDS = PonderTag.create("fluids").item((IItemProvider)AllBlocks.FLUID_PIPE.get(), true, false).defaultLang("Fluid Manipulators", "Components which help relaying and making use of Fluids").addToIndex();
    public static final PonderTag LOGISTICS = PonderTag.create("logistics").item((IItemProvider)Blocks.field_150486_ae, true, false).defaultLang("Item Transportation", "Components which help moving items around").addToIndex();
    public static final PonderTag REDSTONE = PonderTag.create("redstone").item((IItemProvider)Items.field_151137_ax, true, false).defaultLang("Logic Components", "Components which help with redstone engineering").addToIndex();
    public static final PonderTag DECORATION = PonderTag.create("decoration").item((IItemProvider)Items.field_221912_fn, true, false).defaultLang("Aesthetics", "Components used mostly for decorative purposes");
    public static final PonderTag CREATIVE = PonderTag.create("creative").item((IItemProvider)AllBlocks.CREATIVE_CRATE.get(), true, false).defaultLang("Creative Mode", "Components not usually available for Survival Mode").addToIndex();
    public static final PonderTag MOVEMENT_ANCHOR = PonderTag.create("movement_anchor").item((IItemProvider)AllBlocks.MECHANICAL_PISTON.get(), true, false).defaultLang("Movement Anchors", "Components which allow the creation of moving contraptions, animating an attached structure in a variety of ways").addToIndex();
    public static final PonderTag CONTRAPTION_ACTOR = PonderTag.create("contraption_actor").item((IItemProvider)AllBlocks.MECHANICAL_HARVESTER.get(), true, false).defaultLang("Contraption Actors", "Components which expose special behaviour when attached to a moving contraption").addToIndex();
    public static final PonderTag CONTRAPTION_ASSEMBLY = PonderTag.create("contraption_assembly").item((IItemProvider)AllItems.SUPER_GLUE.get(), true, false).defaultLang("Block Attachment Utility", "Tools and Components used to assemble structures moved as an animated Contraption").addToIndex();
    public static final PonderTag SAILS = PonderTag.create("windmill_sails").item((IItemProvider)AllBlocks.WINDMILL_BEARING.get(), true, true).defaultLang("Sails for Windmill Bearings", "Blocks that count towards the strength of a Windmill Contraption when assembled. Each of these have equal efficiency in doing so.");
    public static final PonderTag ARM_TARGETS = PonderTag.create("arm_targets").item((IItemProvider)AllBlocks.MECHANICAL_ARM.get()).defaultLang("Targets for Mechanical Arms", "Components which can be selected as inputs or outputs to the Mechanical Arm");
    private final ResourceLocation id;
    private ResourceLocation icon;
    private ItemStack itemIcon = ItemStack.field_190927_a;
    private ItemStack mainItem = ItemStack.field_190927_a;

    public PonderTag(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ItemStack getMainItem() {
        return this.mainItem;
    }

    public String getTitle() {
        return PonderLocalization.getTag(this.id);
    }

    public String getDescription() {
        return PonderLocalization.getTagDescription(this.id);
    }

    public PonderTag defaultLang(String title, String description) {
        PonderLocalization.registerTag(this.id, title, description);
        return this;
    }

    public PonderTag addToIndex() {
        PonderRegistry.TAGS.listTag(this);
        return this;
    }

    public PonderTag icon(ResourceLocation location) {
        this.icon = new ResourceLocation(location.func_110624_b(), "textures/ponder/tag/" + location.func_110623_a() + ".png");
        return this;
    }

    public PonderTag icon(String location) {
        this.icon = new ResourceLocation(this.id.func_110624_b(), "textures/ponder/tag/" + location + ".png");
        return this;
    }

    public PonderTag idAsIcon() {
        return this.icon(this.id);
    }

    public PonderTag item(IItemProvider item, boolean useAsIcon, boolean useAsMainItem) {
        if (useAsIcon) {
            this.itemIcon = new ItemStack(item);
        }
        if (useAsMainItem) {
            this.mainItem = new ItemStack(item);
        }
        return this;
    }

    public PonderTag item(IItemProvider item) {
        return this.item(item, true, true);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack ms, AbstractGui screen, int x, int y) {
        ms.func_227860_a_();
        ms.func_227861_a_((double)x, (double)y, 0.0);
        if (this.icon != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.icon);
            ms.func_227862_a_(0.25f, 0.25f, 1.0f);
            AbstractGui.func_238464_a_((MatrixStack)ms, (int)0, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        } else if (!this.itemIcon.func_190926_b()) {
            ms.func_227861_a_(-4.0, -4.0, 0.0);
            ms.func_227862_a_(1.5f, 1.5f, 1.5f);
            GuiGameElement.of(this.itemIcon).render(ms);
        }
        ms.func_227865_b_();
    }

    private static PonderTag create(String id) {
        return new PonderTag(Create.asResource(id));
    }

    public static void register() {
    }

    static /* synthetic */ PonderTag access$000(String x0) {
        return PonderTag.create(x0);
    }

    public static class Highlight {
        public static final PonderTag ALL = PonderTag.access$000("_all");
    }
}

