/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.schematics.client.tools.Tools;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ToolSelectionScreen
extends Screen {
    public final String scrollToCycle = Lang.translate("gui.toolmenu.cycle", new Object[0]).getString();
    public final String holdToFocus = "gui.toolmenu.focusKey";
    protected List<Tools> tools;
    protected Consumer<Tools> callback;
    public boolean field_230699_a_;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;

    public ToolSelectionScreen(List<Tools> tools, Consumer<Tools> callback) {
        super((ITextComponent)new StringTextComponent("Tool Selection"));
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.tools = tools;
        this.callback = callback;
        this.field_230699_a_ = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        callback.accept(tools.get(this.selection));
        this.w = Math.max(tools.size() * 50 + 30, 220);
        this.h = 30;
    }

    public void setSelectedElement(Tools tool) {
        if (!this.tools.contains((Object)tool)) {
            return;
        }
        this.selection = this.tools.indexOf((Object)tool);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(MatrixStack matrixStack, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow mainWindow = mc.func_228018_at_();
        if (!this.initialized) {
            this.func_231158_b_(mc, mainWindow.func_198107_o(), mainWindow.func_198087_p());
        }
        int x = (mainWindow.func_198107_o() - this.w) / 2 + 15;
        int y = mainWindow.func_198087_p() - this.h - 75;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)(-this.yOffset), this.field_230699_a_ ? 100.0 : 0.0);
        AllGuiTextures gray = AllGuiTextures.HUD_BACKGROUND;
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.field_230699_a_ ? 0.875f : 0.5f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(gray.location);
        ToolSelectionScreen.func_238463_a_((MatrixStack)matrixStack, (int)(x - 15), (int)y, (float)gray.startX, (float)gray.startY, (int)this.w, (int)this.h, (int)gray.width, (int)gray.height);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<ITextComponent> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * 255.0f) << 24;
        if (toolTipAlpha > 0.25f) {
            RenderSystem.color4f((float)0.7f, (float)0.7f, (float)0.8f, (float)toolTipAlpha);
            ToolSelectionScreen.func_238463_a_((MatrixStack)matrixStack, (int)(x - 15), (int)(y + 33), (float)gray.startX, (float)gray.startY, (int)this.w, (int)(this.h + 22), (int)gray.width, (int)gray.height);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (toolTip.size() > 0) {
                this.field_230712_o_.func_243248_b(matrixStack, toolTip.get(0), (float)(x - 10), (float)(y + 38), 0xEEEEEE + stringAlphaComponent);
            }
            if (toolTip.size() > 1) {
                this.field_230712_o_.func_243248_b(matrixStack, toolTip.get(1), (float)(x - 10), (float)(y + 50), 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 2) {
                this.field_230712_o_.func_243248_b(matrixStack, toolTip.get(2), (float)(x - 10), (float)(y + 60), 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 3) {
                this.field_230712_o_.func_243248_b(matrixStack, toolTip.get(3), (float)(x - 10), (float)(y + 72), 0xCCCCDD + stringAlphaComponent);
            }
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tools.size() > 1) {
            String keyName = AllKeys.TOOL_MENU.getBoundKey();
            int width = this.field_230706_i_.func_228018_at_().func_198107_o();
            if (!this.field_230699_a_) {
                ToolSelectionScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)Lang.translate("gui.toolmenu.focusKey", keyName), (int)(width / 2), (int)(y - 10), (int)0xCCDDFF);
            } else {
                ToolSelectionScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)this.scrollToCycle, (int)(width / 2), (int)(y - 10), (int)0xCCDDFF);
            }
        } else {
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            float alpha;
            matrixStack.func_227860_a_();
            float f = alpha = this.field_230699_a_ ? 1.0f : 0.2f;
            if (i == this.selection) {
                matrixStack.func_227861_a_(0.0, -10.0, 0.0);
                ToolSelectionScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)this.tools.get(i).getDisplayName().getString(), (int)(x + i * 50 + 24), (int)(y + 28), (int)0xCCDDFF);
                alpha = 1.0f;
            }
            RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
            this.tools.get(i).getIcon().draw(matrixStack, (AbstractGui)this, x + i * 50 + 16, y + 12);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.tools.get(i).getIcon().draw(matrixStack, (AbstractGui)this, x + i * 50 + 16, y + 11);
            matrixStack.func_227865_b_();
        }
        RenderSystem.enableBlend();
        matrixStack.func_227865_b_();
    }

    public void update() {
        this.yOffset = this.field_230699_a_ ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public void renderPassive(MatrixStack matrixStack, float partialTicks) {
        this.draw(matrixStack, partialTicks);
    }

    public void func_231175_as__() {
        this.callback.accept(this.tools.get(this.selection));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.initialized = true;
    }
}

