/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.inventories.CreativeCrateBlock;
import com.simibubi.create.content.schematics.block.SchematicannonContainer;
import com.simibubi.create.content.schematics.block.SchematicannonTileEntity;
import com.simibubi.create.content.schematics.packet.ConfigureSchematicannonPacket;
import com.simibubi.create.foundation.gui.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SchematicannonScreen
extends AbstractSimiContainerScreen<SchematicannonContainer> {
    private static final AllGuiTextures BG_BOTTOM = AllGuiTextures.SCHEMATICANNON_BOTTOM;
    private static final AllGuiTextures BG_TOP = AllGuiTextures.SCHEMATICANNON_TOP;
    protected Vector<Indicator> replaceLevelIndicators;
    protected Vector<IconButton> replaceLevelButtons;
    protected IconButton skipMissingButton;
    protected Indicator skipMissingIndicator;
    protected IconButton skipTilesButton;
    protected Indicator skipTilesIndicator;
    protected IconButton playButton;
    protected Indicator playIndicator;
    protected IconButton pauseButton;
    protected Indicator pauseIndicator;
    protected IconButton resetButton;
    protected Indicator resetIndicator;
    private List<Rectangle2d> extraAreas = Collections.emptyList();
    protected List<Widget> placementSettingWidgets;
    private final ITextComponent listPrinter = Lang.translate("gui.schematicannon.listPrinter", new Object[0]);
    private final String _gunpowderLevel = "gui.schematicannon.gunpowderLevel";
    private final String _shotsRemaining = "gui.schematicannon.shotsRemaining";
    private final String _showSettings = "gui.schematicannon.showOptions";
    private final String _shotsRemainingWithBackup = "gui.schematicannon.shotsRemainingWithBackup";
    private final String _slotGunpowder = "gui.schematicannon.slot.gunpowder";
    private final String _slotListPrinter = "gui.schematicannon.slot.listPrinter";
    private final String _slotSchematic = "gui.schematicannon.slot.schematic";
    private final ITextComponent optionEnabled = Lang.translate("gui.schematicannon.optionEnabled", new Object[0]);
    private final ITextComponent optionDisabled = Lang.translate("gui.schematicannon.optionDisabled", new Object[0]);
    private final ItemStack renderedItem = AllBlocks.SCHEMATICANNON.asStack();
    private IconButton confirmButton;
    private IconButton showSettingsButton;
    private Indicator showSettingsIndicator;

    public SchematicannonScreen(SchematicannonContainer container, PlayerInventory inventory, ITextComponent title) {
        super(container, inventory, title);
        this.placementSettingWidgets = new ArrayList<Widget>();
    }

    @Override
    protected void func_231160_c_() {
        this.setWindowSize(SchematicannonScreen.BG_TOP.width, SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height + 2 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(-10 + (this.field_230708_k_ % 2 == 0 ? 0 : -1), 0);
        super.func_231160_c_();
        this.widgets.clear();
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        this.playButton = new IconButton(x + 75, y + 86, AllIcons.I_PLAY);
        this.playIndicator = new Indicator(x + 75, y + 79, StringTextComponent.field_240750_d_);
        this.pauseButton = new IconButton(x + 93, y + 86, AllIcons.I_PAUSE);
        this.pauseIndicator = new Indicator(x + 93, y + 79, StringTextComponent.field_240750_d_);
        this.resetButton = new IconButton(x + 111, y + 86, AllIcons.I_STOP);
        this.resetIndicator = new Indicator(x + 111, y + 79, StringTextComponent.field_240750_d_);
        this.resetIndicator.state = Indicator.State.RED;
        Collections.addAll(this.widgets, new AbstractSimiWidget[]{this.playButton, this.playIndicator, this.pauseButton, this.pauseIndicator, this.resetButton, this.resetIndicator});
        this.confirmButton = new IconButton(x + 180, y + 117, AllIcons.I_CONFIRM);
        this.widgets.add(this.confirmButton);
        this.showSettingsButton = new IconButton(x + 9, y + 117, AllIcons.I_PLACEMENT_SETTINGS);
        this.showSettingsButton.setToolTip((ITextComponent)Lang.translate("gui.schematicannon.showOptions", new Object[0]));
        this.widgets.add(this.showSettingsButton);
        this.showSettingsIndicator = new Indicator(x + 9, y + 111, StringTextComponent.field_240750_d_);
        this.widgets.add(this.showSettingsIndicator);
        this.extraAreas = ImmutableList.of((Object)new Rectangle2d(x + SchematicannonScreen.BG_TOP.width, y + SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height - 62, 84, 92));
        this.func_231023_e_();
    }

    private void initPlacementSettings() {
        this.widgets.removeAll(this.placementSettingWidgets);
        this.placementSettingWidgets.clear();
        if (this.placementSettingsHidden()) {
            return;
        }
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        this.replaceLevelButtons = new Vector(4);
        this.replaceLevelIndicators = new Vector(4);
        ImmutableList icons = ImmutableList.of((Object)AllIcons.I_DONT_REPLACE, (Object)AllIcons.I_REPLACE_SOLID, (Object)AllIcons.I_REPLACE_ANY, (Object)AllIcons.I_REPLACE_EMPTY);
        ImmutableList toolTips = ImmutableList.of((Object)Lang.translate("gui.schematicannon.option.dontReplaceSolid", new Object[0]), (Object)Lang.translate("gui.schematicannon.option.replaceWithSolid", new Object[0]), (Object)Lang.translate("gui.schematicannon.option.replaceWithAny", new Object[0]), (Object)Lang.translate("gui.schematicannon.option.replaceWithEmpty", new Object[0]));
        for (int i = 0; i < 4; ++i) {
            this.replaceLevelIndicators.add(new Indicator(x + 33 + i * 18, y + 111, StringTextComponent.field_240750_d_));
            this.replaceLevelButtons.add(new IconButton(x + 33 + i * 18, y + 117, (AllIcons)icons.get(i)));
            this.replaceLevelButtons.get(i).setToolTip((ITextComponent)toolTips.get(i));
        }
        this.placementSettingWidgets.addAll(this.replaceLevelButtons);
        this.placementSettingWidgets.addAll(this.replaceLevelIndicators);
        this.skipMissingButton = new IconButton(x + 111, y + 117, AllIcons.I_SKIP_MISSING);
        this.skipMissingButton.setToolTip((ITextComponent)Lang.translate("gui.schematicannon.option.skipMissing", new Object[0]));
        this.skipMissingIndicator = new Indicator(x + 111, y + 111, StringTextComponent.field_240750_d_);
        Collections.addAll(this.placementSettingWidgets, new AbstractSimiWidget[]{this.skipMissingButton, this.skipMissingIndicator});
        this.skipTilesButton = new IconButton(x + 129, y + 117, AllIcons.I_SKIP_TILES);
        this.skipTilesButton.setToolTip((ITextComponent)Lang.translate("gui.schematicannon.option.skipTileEntities", new Object[0]));
        this.skipTilesIndicator = new Indicator(x + 129, y + 111, StringTextComponent.field_240750_d_);
        Collections.addAll(this.placementSettingWidgets, new AbstractSimiWidget[]{this.skipTilesButton, this.skipTilesIndicator});
        this.widgets.addAll(this.placementSettingWidgets);
    }

    protected boolean placementSettingsHidden() {
        return this.showSettingsIndicator.state == Indicator.State.OFF;
    }

    public void func_231023_e_() {
        SchematicannonTileEntity te = ((SchematicannonContainer)this.field_147002_h).getTileEntity();
        if (!this.placementSettingsHidden()) {
            for (int replaceMode = 0; replaceMode < this.replaceLevelButtons.size(); ++replaceMode) {
                this.replaceLevelIndicators.get((int)replaceMode).state = replaceMode == te.replaceMode ? Indicator.State.ON : Indicator.State.OFF;
            }
            this.skipMissingIndicator.state = te.skipMissing ? Indicator.State.ON : Indicator.State.OFF;
            this.skipTilesIndicator.state = !te.replaceTileEntities ? Indicator.State.ON : Indicator.State.OFF;
        }
        this.playIndicator.state = Indicator.State.OFF;
        this.pauseIndicator.state = Indicator.State.OFF;
        this.resetIndicator.state = Indicator.State.OFF;
        switch (te.state) {
            case PAUSED: {
                this.pauseIndicator.state = Indicator.State.YELLOW;
                this.playButton.field_230693_o_ = true;
                this.pauseButton.field_230693_o_ = false;
                this.resetButton.field_230693_o_ = true;
                break;
            }
            case RUNNING: {
                this.playIndicator.state = Indicator.State.GREEN;
                this.playButton.field_230693_o_ = false;
                this.pauseButton.field_230693_o_ = true;
                this.resetButton.field_230693_o_ = true;
                break;
            }
            case STOPPED: {
                this.resetIndicator.state = Indicator.State.RED;
                this.playButton.field_230693_o_ = true;
                this.pauseButton.field_230693_o_ = false;
                this.resetButton.field_230693_o_ = false;
                break;
            }
        }
        this.handleTooltips();
        super.func_231023_e_();
    }

    protected void handleTooltips() {
        if (this.placementSettingsHidden()) {
            return;
        }
        for (Widget w : this.placementSettingWidgets) {
            IconButton button;
            if (!(w instanceof IconButton) || (button = (IconButton)w).getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add((ITextComponent)TooltipHelper.holdShift(ItemDescription.Palette.Blue, SchematicannonScreen.func_231173_s_()));
        }
        if (SchematicannonScreen.func_231173_s_()) {
            this.fillToolTip(this.skipMissingButton, this.skipMissingIndicator, "skipMissing");
            this.fillToolTip(this.skipTilesButton, this.skipTilesIndicator, "skipTileEntities");
            this.fillToolTip(this.replaceLevelButtons.get(0), this.replaceLevelIndicators.get(0), "dontReplaceSolid");
            this.fillToolTip(this.replaceLevelButtons.get(1), this.replaceLevelIndicators.get(1), "replaceWithSolid");
            this.fillToolTip(this.replaceLevelButtons.get(2), this.replaceLevelIndicators.get(2), "replaceWithAny");
            this.fillToolTip(this.replaceLevelButtons.get(3), this.replaceLevelIndicators.get(3), "replaceWithEmpty");
        }
    }

    private void fillToolTip(IconButton button, Indicator indicator, String tooltipKey) {
        if (!button.func_230449_g_()) {
            return;
        }
        boolean enabled = indicator.state == Indicator.State.ON;
        List<ITextComponent> tip = button.getToolTip();
        tip.add((ITextComponent)(enabled ? this.optionEnabled : this.optionDisabled).func_230531_f_().func_240699_a_(TextFormatting.BLUE));
        tip.addAll(TooltipHelper.cutTextComponent((ITextComponent)Lang.translate("gui.schematicannon.option." + tooltipKey + ".description", new Object[0]), TextFormatting.GRAY, TextFormatting.GRAY));
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.field_147009_r + SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height + 2;
        this.renderPlayerInventory(ms, invX, invY);
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        BG_TOP.draw(ms, (AbstractGui)this, x, y);
        BG_BOTTOM.draw(ms, (AbstractGui)this, x, y + SchematicannonScreen.BG_TOP.height);
        SchematicannonTileEntity te = ((SchematicannonContainer)this.field_147002_h).getTileEntity();
        this.renderPrintingProgress(ms, x, y, te.schematicProgress);
        this.renderFuelBar(ms, x, y, te.fuelLevel);
        this.renderChecklistPrinterProgress(ms, x, y, te.bookPrintingProgress);
        if (!te.inventory.getStackInSlot(0).func_190926_b()) {
            this.renderBlueprintHighlight(ms, x, y);
        }
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(this.renderedItem).at(x + SchematicannonScreen.BG_TOP.width, y + SchematicannonScreen.BG_TOP.height + SchematicannonScreen.BG_BOTTOM.height - 48, -200.0f)).scale(5.0).render(ms);
        SchematicannonScreen.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(x + (SchematicannonScreen.BG_TOP.width - 8) / 2), (int)(y + 3), (int)0xFFFFFF);
        TranslationTextComponent msg = Lang.translate("schematicannon.status." + te.statusMsg, new Object[0]);
        int stringWidth = this.field_230712_o_.func_238414_a_((ITextProperties)msg);
        if (te.missingItem != null) {
            stringWidth += 16;
            ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of(te.missingItem).at(x + 128, y + 49, 100.0f)).scale(1.0).render(ms);
        }
        this.field_230712_o_.func_243246_a(ms, (ITextComponent)msg, (float)(x + 103 - stringWidth / 2), (float)(y + 53), 0xCCDDFF);
    }

    protected void renderBlueprintHighlight(MatrixStack matrixStack, int x, int y) {
        AllGuiTextures.SCHEMATICANNON_HIGHLIGHT.draw(matrixStack, (AbstractGui)this, x + 10, y + 60);
    }

    protected void renderPrintingProgress(MatrixStack matrixStack, int x, int y, float progress) {
        progress = Math.min(progress, 1.0f);
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_PROGRESS;
        sprite.bind();
        this.func_238474_b_(matrixStack, x + 44, y + 64, sprite.startX, sprite.startY, (int)((float)sprite.width * progress), sprite.height);
    }

    protected void renderChecklistPrinterProgress(MatrixStack matrixStack, int x, int y, float progress) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_CHECKLIST_PROGRESS;
        sprite.bind();
        this.func_238474_b_(matrixStack, x + 154, y + 20, sprite.startX, sprite.startY, (int)((float)sprite.width * progress), sprite.height);
    }

    protected void renderFuelBar(MatrixStack matrixStack, int x, int y, float amount) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_FUEL;
        if (((SchematicannonContainer)this.field_147002_h).getTileEntity().hasCreativeCrate) {
            AllGuiTextures.SCHEMATICANNON_FUEL_CREATIVE.draw(matrixStack, (AbstractGui)this, x + 36, y + 19);
            return;
        }
        sprite.bind();
        this.func_238474_b_(matrixStack, x + 36, y + 19, sprite.startX, sprite.startY, (int)((float)sprite.width * amount), sprite.height);
    }

    @Override
    protected void renderWindowForeground(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        SchematicannonTileEntity te = ((SchematicannonContainer)this.field_147002_h).getTileEntity();
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        int fuelX = x + 36;
        int fuelY = y + 19;
        if (mouseX >= fuelX && mouseY >= fuelY && mouseX <= fuelX + AllGuiTextures.SCHEMATICANNON_FUEL.width && mouseY <= fuelY + AllGuiTextures.SCHEMATICANNON_FUEL.height) {
            List<ITextComponent> tooltip = this.getFuelLevelTooltip(te);
            this.func_243308_b(matrixStack, tooltip, mouseX, mouseY);
        }
        if (this.field_147006_u != null && !this.field_147006_u.func_75216_d()) {
            if (this.field_147006_u.field_75222_d == 0) {
                this.func_243308_b(matrixStack, TooltipHelper.cutTextComponent((ITextComponent)Lang.translate("gui.schematicannon.slot.schematic", new Object[0]), TextFormatting.GRAY, TextFormatting.BLUE), mouseX, mouseY);
            }
            if (this.field_147006_u.field_75222_d == 2) {
                this.func_243308_b(matrixStack, TooltipHelper.cutTextComponent((ITextComponent)Lang.translate("gui.schematicannon.slot.listPrinter", new Object[0]), TextFormatting.GRAY, TextFormatting.BLUE), mouseX, mouseY);
            }
            if (this.field_147006_u.field_75222_d == 4) {
                this.func_243308_b(matrixStack, TooltipHelper.cutTextComponent((ITextComponent)Lang.translate("gui.schematicannon.slot.gunpowder", new Object[0]), TextFormatting.GRAY, TextFormatting.BLUE), mouseX, mouseY);
            }
        }
        if (te.missingItem != null) {
            int missingBlockX = x + 128;
            int missingBlockY = y + 49;
            if (mouseX >= missingBlockX && mouseY >= missingBlockY && mouseX <= missingBlockX + 16 && mouseY <= missingBlockY + 16) {
                this.func_230457_a_(matrixStack, te.missingItem, mouseX, mouseY);
            }
        }
        int paperX = x + 112;
        int paperY = y + 19;
        if (mouseX >= paperX && mouseY >= paperY && mouseX <= paperX + 16 && mouseY <= paperY + 16) {
            this.func_238652_a_(matrixStack, this.listPrinter, mouseX, mouseY);
        }
        super.renderWindowForeground(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected List<ITextComponent> getFuelLevelTooltip(SchematicannonTileEntity te) {
        double fuelUsageRate = te.getFuelUsageRate();
        int shotsLeft = (int)((double)te.fuelLevel / fuelUsageRate);
        int shotsLeftWithItems = (int)((double)shotsLeft + (double)te.inventory.getStackInSlot(4).func_190916_E() * (te.getFuelAddedByGunPowder() / fuelUsageRate));
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (te.hasCreativeCrate) {
            tooltip.add((ITextComponent)Lang.translate("gui.schematicannon.gunpowderLevel", "100"));
            tooltip.add((ITextComponent)new StringTextComponent("(").func_230529_a_((ITextComponent)new TranslationTextComponent(((CreativeCrateBlock)AllBlocks.CREATIVE_CRATE.get()).func_149739_a())).func_240702_b_(")").func_240699_a_(TextFormatting.DARK_PURPLE));
            return tooltip;
        }
        int fillPercent = (int)(te.fuelLevel * 100.0f);
        tooltip.add((ITextComponent)Lang.translate("gui.schematicannon.gunpowderLevel", fillPercent));
        tooltip.add((ITextComponent)Lang.translate("gui.schematicannon.shotsRemaining", new StringTextComponent(Integer.toString(shotsLeft)).func_240699_a_(TextFormatting.BLUE)).func_240699_a_(TextFormatting.GRAY));
        if (shotsLeftWithItems != shotsLeft) {
            tooltip.add((ITextComponent)Lang.translate("gui.schematicannon.shotsRemainingWithBackup", new StringTextComponent(Integer.toString(shotsLeftWithItems)).func_240699_a_(TextFormatting.BLUE)).func_240699_a_(TextFormatting.GRAY));
        }
        return tooltip;
    }

    @Override
    public boolean func_231044_a_(double x, double y, int button) {
        if (this.showSettingsButton.func_230449_g_()) {
            this.showSettingsIndicator.state = this.placementSettingsHidden() ? Indicator.State.GREEN : Indicator.State.OFF;
            this.initPlacementSettings();
        }
        if (this.confirmButton.func_230449_g_()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return true;
        }
        if (!this.placementSettingsHidden()) {
            for (int replaceMode = 0; replaceMode < this.replaceLevelButtons.size(); ++replaceMode) {
                if (!this.replaceLevelButtons.get(replaceMode).func_230449_g_() || ((SchematicannonContainer)this.field_147002_h).getTileEntity().replaceMode == replaceMode) continue;
                this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.values()[replaceMode], true);
            }
            if (this.skipMissingButton.func_230449_g_()) {
                this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_MISSING, !((SchematicannonContainer)this.field_147002_h).getTileEntity().skipMissing);
            }
            if (this.skipTilesButton.func_230449_g_()) {
                this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_TILES, !((SchematicannonContainer)this.field_147002_h).getTileEntity().replaceTileEntities);
            }
        }
        if (this.playButton.func_230449_g_() && this.playButton.field_230693_o_) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PLAY, true);
        }
        if (this.pauseButton.func_230449_g_() && this.pauseButton.field_230693_o_) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PAUSE, true);
        }
        if (this.resetButton.func_230449_g_() && this.resetButton.field_230693_o_) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.STOP, true);
        }
        return super.func_231044_a_(x, y, button);
    }

    @Override
    public List<Rectangle2d> getExtraAreas() {
        return this.extraAreas;
    }

    protected void sendOptionUpdate(ConfigureSchematicannonPacket.Option option, boolean set) {
        AllPackets.channel.sendToServer((Object)new ConfigureSchematicannonPacket(option, set));
    }
}

