/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.google.common.collect.ImmutableMap;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeBlock;
import com.simibubi.create.content.logistics.block.redstone.NixieTubeTileEntity;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Couple;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.text.Style;

public class NixieTubeRenderer
extends SafeTileEntityRenderer<NixieTubeTileEntity> {
    private Random r = new Random();
    public static final Map<DyeColor, Couple<Integer>> DYE_TABLE = new ImmutableMap.Builder().put((Object)DyeColor.BLACK, Couple.create(4538427, 2170911)).put((Object)DyeColor.RED, Couple.create(11614519, 6498103)).put((Object)DyeColor.GREEN, Couple.create(2132550, 1925189)).put((Object)DyeColor.BROWN, Couple.create(11306332, 6837054)).put((Object)DyeColor.BLUE, Couple.create(5476833, 5262224)).put((Object)DyeColor.GRAY, Couple.create(6121071, 3224888)).put((Object)DyeColor.LIGHT_GRAY, Couple.create(9803419, 0x707070)).put((Object)DyeColor.PURPLE, Couple.create(10441902, 0x63366C)).put((Object)DyeColor.CYAN, Couple.create(4107188, 3962994)).put((Object)DyeColor.PINK, Couple.create(14002379, 12086165)).put((Object)DyeColor.LIME, Couple.create(10739541, 5222767)).put((Object)DyeColor.YELLOW, Couple.create(15128406, 15313961)).put((Object)DyeColor.LIGHT_BLUE, Couple.create(6934226, 5278373)).put((Object)DyeColor.ORANGE, Couple.create(15635014, 14240039)).put((Object)DyeColor.MAGENTA, Couple.create(15753904, 12600456)).put((Object)DyeColor.WHITE, Couple.create(15592165, 0xBBB6B0)).build();

    public NixieTubeRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(NixieTubeTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        ms.func_227860_a_();
        BlockState blockState = te.func_195044_w();
        MatrixTransformStack.of((MatrixStack)ms).centre().rotateY((double)AngleHelper.horizontalAngle((Direction)blockState.func_177229_b((Property)NixieTubeBlock.field_185512_D)));
        float height = (Boolean)blockState.func_177229_b((Property)NixieTubeBlock.CEILING) != false ? 2.0f : 6.0f;
        float scale = 0.05f;
        Couple<String> s = te.getDisplayedStrings();
        DyeColor color = NixieTubeBlock.colorOf(te.func_195044_w());
        ms.func_227860_a_();
        ms.func_227861_a_(-0.25, 0.0, 0.0);
        ms.func_227862_a_(scale, -scale, scale);
        this.drawTube(ms, buffer, (String)s.getFirst(), height, color);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227861_a_(0.25, 0.0, 0.0);
        ms.func_227862_a_(scale, -scale, scale);
        this.drawTube(ms, buffer, (String)s.getSecond(), height, color);
        ms.func_227865_b_();
        ms.func_227865_b_();
    }

    private void drawTube(MatrixStack ms, IRenderTypeBuffer buffer, String c, float height, DyeColor color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        float charWidth = fontRenderer.func_78256_a(c);
        float shadowOffset = 0.5f;
        float flicker = this.r.nextFloat();
        Couple<Integer> couple = DYE_TABLE.get(color);
        int brightColor = (Integer)couple.getFirst();
        int darkColor = (Integer)couple.getSecond();
        int flickeringBrightColor = Color.mixColors(brightColor, darkColor, flicker / 4.0f);
        ms.func_227860_a_();
        ms.func_227861_a_((double)((charWidth - shadowOffset) / -2.0f), (double)(-height), 0.0);
        NixieTubeRenderer.drawChar(ms, buffer, c, flickeringBrightColor);
        ms.func_227860_a_();
        ms.func_227861_a_((double)shadowOffset, (double)shadowOffset, -0.0625);
        NixieTubeRenderer.drawChar(ms, buffer, c, darkColor);
        ms.func_227865_b_();
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227862_a_(-1.0f, 1.0f, 1.0f);
        ms.func_227861_a_((double)((charWidth - shadowOffset) / -2.0f), (double)(-height), 0.0);
        NixieTubeRenderer.drawChar(ms, buffer, c, darkColor);
        ms.func_227860_a_();
        ms.func_227861_a_((double)(-shadowOffset), (double)shadowOffset, -0.0625);
        NixieTubeRenderer.drawChar(ms, buffer, c, Color.mixColors(darkColor, 0, 0.35f));
        ms.func_227865_b_();
        ms.func_227865_b_();
    }

    private static void drawChar(MatrixStack ms, IRenderTypeBuffer buffer, String c, int color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_228079_a_(c, 0.0f, 0.0f, color, false, ms.func_227866_c_().func_227870_a_(), buffer, false, 0, 0xF000F0);
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            TexturedGlyph texturedglyph = fontRenderer.func_238419_a_(Style.field_240708_a_).func_228157_b_();
            ((IRenderTypeBuffer.Impl)buffer).func_228462_a_(texturedglyph.func_228163_a_(false));
        }
    }
}

