/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids;

import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.contraptions.fluids.particle.FluidParticleData;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidFX {
    static Random r = new Random();

    public static void splash(BlockPos pos, FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == Fluids.field_204541_a) {
            return;
        }
        FluidState defaultState = fluid.func_207188_f();
        if (defaultState == null || defaultState.func_206888_e()) {
            return;
        }
        BlockParticleData blockParticleData = new BlockParticleData(ParticleTypes.field_197611_d, defaultState.func_206883_i());
        Vector3d center = VecHelper.getCenterOf((Vector3i)pos);
        for (int i = 0; i < 20; ++i) {
            Vector3d v = VecHelper.offsetRandomly(Vector3d.field_186680_a, r, 0.25f);
            FluidFX.particle((IParticleData)blockParticleData, center.func_178787_e(v), v);
        }
    }

    public static IParticleData getFluidParticle(FluidStack fluid) {
        return new FluidParticleData(AllParticleTypes.FLUID_PARTICLE.get(), fluid);
    }

    public static IParticleData getDrippingParticle(FluidStack fluid) {
        Object particle = null;
        if (FluidHelper.isWater(fluid.getFluid())) {
            particle = ParticleTypes.field_197618_k;
        }
        if (FluidHelper.isLava(fluid.getFluid())) {
            particle = ParticleTypes.field_197617_j;
        }
        if (particle == null) {
            particle = new FluidParticleData(AllParticleTypes.FLUID_DRIP.get(), fluid);
        }
        return particle;
    }

    public static void spawnRimParticles(World world, BlockPos pos, Direction side, int amount, IParticleData particle, float rimRadius) {
        Vector3d directionVec = Vector3d.func_237491_b_((Vector3i)side.func_176730_m());
        for (int i = 0; i < amount; ++i) {
            Vector3d vec = VecHelper.offsetRandomly(Vector3d.field_186680_a, r, 1.0f).func_72432_b();
            vec = VecHelper.clampComponentWise(vec, rimRadius).func_216369_h(VecHelper.axisAlingedPlaneOf(directionVec)).func_178787_e(directionVec.func_186678_a(0.45 + (double)(r.nextFloat() / 16.0f)));
            Vector3d m = vec.func_186678_a((double)0.05f);
            vec = vec.func_178787_e(VecHelper.getCenterOf((Vector3i)pos));
            world.func_195589_b(particle, vec.field_72450_a, vec.field_72448_b - 0.0625, vec.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
        }
    }

    public static void spawnPouringLiquid(World world, BlockPos pos, int amount, IParticleData particle, float rimRadius, Vector3d directionVec, boolean inbound) {
        for (int i = 0; i < amount; ++i) {
            Vector3d vec = VecHelper.offsetRandomly(Vector3d.field_186680_a, r, rimRadius * 0.75f);
            vec = vec.func_216369_h(VecHelper.axisAlingedPlaneOf(directionVec)).func_178787_e(directionVec.func_186678_a(0.5 + (double)(r.nextFloat() / 4.0f)));
            Vector3d m = vec.func_186678_a(0.25);
            Vector3d centerOf = VecHelper.getCenterOf((Vector3i)pos);
            vec = vec.func_178787_e(centerOf);
            if (inbound) {
                vec = vec.func_178787_e(m);
                m = centerOf.func_178787_e(directionVec.func_186678_a(0.5)).func_178788_d(vec).func_186678_a(0.0625);
            }
            world.func_195589_b(particle, vec.field_72450_a, vec.field_72448_b - 0.0625, vec.field_72449_c, m.field_72450_a, m.field_72448_b, m.field_72449_c);
        }
    }

    private static void particle(IParticleData data, Vector3d pos, Vector3d motion) {
        FluidFX.world().func_195594_a(data, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
    }

    private static World world() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

