/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crusher;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crusher.CrushingWheelControllerTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CrushingWheelControllerBlock
extends DirectionalBlock
implements ITE<CrushingWheelControllerTileEntity> {
    public static final BooleanProperty VALID = BooleanProperty.func_177716_a((String)"valid");

    public CrushingWheelControllerBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.CRUSHING_WHEEL_CONTROLLER.create();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{VALID});
        builder.func_206894_a(new Property[]{field_176387_N});
        super.func_206840_a(builder);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!((Boolean)state.func_177229_b((Property)VALID)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((Property)field_176387_N);
        Direction.Axis axis = facing.func_176740_k();
        this.checkEntityForProcessing(worldIn, pos, entityIn);
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            if (te.processingEntity == entityIn) {
                entityIn.func_213295_a(state, new Vector3d(axis == Direction.Axis.X ? (double)0.05f : 0.25, axis == Direction.Axis.Y ? (double)0.05f : 0.25, axis == Direction.Axis.Z ? (double)0.05f : 0.25));
            }
        });
    }

    public void checkEntityForProcessing(World worldIn, BlockPos pos, Entity entityIn) {
        CompoundNBT data;
        CrushingWheelControllerTileEntity te = (CrushingWheelControllerTileEntity)this.getTileEntity((IBlockReader)worldIn, pos);
        if (te == null) {
            return;
        }
        if (te.crushingspeed == 0.0f) {
            return;
        }
        if (entityIn instanceof ItemEntity) {
            ((ItemEntity)entityIn).func_174867_a(10);
        }
        if ((data = entityIn.getPersistentData()).func_74764_b("BypassCrushingWheel") && pos.equals((Object)NBTUtil.func_186861_c((CompoundNBT)data.func_74775_l("BypassCrushingWheel")))) {
            return;
        }
        if (te.isOccupied()) {
            return;
        }
        boolean isPlayer = entityIn instanceof PlayerEntity;
        if (isPlayer && ((PlayerEntity)entityIn).func_184812_l_()) {
            return;
        }
        if (isPlayer && entityIn.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            return;
        }
        te.startCrushing(entityIn);
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)stateIn.func_177229_b((Property)VALID)).booleanValue()) {
            return;
        }
        if (rand.nextInt(1) != 0) {
            return;
        }
        double d0 = (float)pos.func_177958_n() + rand.nextFloat();
        double d1 = (float)pos.func_177956_o() + rand.nextFloat();
        double d2 = (float)pos.func_177952_p() + rand.nextFloat();
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197614_g, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        this.updateSpeed(stateIn, worldIn, currentPos);
        return stateIn;
    }

    public void updateSpeed(BlockState state, IWorld world, BlockPos pos) {
        this.withTileEntityDo((IBlockReader)world, pos, te -> {
            if (!((Boolean)state.func_177229_b((Property)VALID)).booleanValue()) {
                if (te.crushingspeed != 0.0f) {
                    te.crushingspeed = 0.0f;
                    te.sendData();
                }
                return;
            }
            for (Direction d : Iterate.directions) {
                TileEntity adjTe;
                BlockState neighbour = world.func_180495_p(pos.func_177972_a(d));
                if (!AllBlocks.CRUSHING_WHEEL.has(neighbour) || neighbour.func_177229_b((Property)BlockStateProperties.field_208148_A) == d.func_176740_k() || !((adjTe = world.func_175625_s(pos.func_177972_a(d))) instanceof KineticTileEntity)) continue;
                te.crushingspeed = Math.abs(((KineticTileEntity)adjTe).getSpeed() / 50.0f);
                te.sendData();
                break;
            }
        });
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape standardShape = AllShapes.CRUSHING_WHEEL_CONTROLLER_COLLISION.get((Direction)state.func_177229_b((Property)field_176387_N));
        if (!((Boolean)state.func_177229_b((Property)VALID)).booleanValue()) {
            return standardShape;
        }
        Entity entity = context.getEntity();
        if (entity == null) {
            return standardShape;
        }
        CompoundNBT data = entity.getPersistentData();
        if (data.func_74764_b("BypassCrushingWheel") && pos.equals((Object)NBTUtil.func_186861_c((CompoundNBT)data.func_74775_l("BypassCrushingWheel"))) && state.func_177229_b((Property)field_176387_N) != Direction.UP) {
            return VoxelShapes.func_197880_a();
        }
        CrushingWheelControllerTileEntity te = (CrushingWheelControllerTileEntity)this.getTileEntity(worldIn, pos);
        if (te != null && te.processingEntity == entity) {
            return VoxelShapes.func_197880_a();
        }
        return standardShape;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasTileEntity() || state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> ItemHelper.dropContents(worldIn, pos, (IItemHandler)te.inventory));
        worldIn.func_175713_t(pos);
    }

    @Override
    public Class<CrushingWheelControllerTileEntity> getTileEntityClass() {
        return CrushingWheelControllerTileEntity.class;
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType type) {
        return false;
    }
}

