/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crafter;

import com.google.gson.JsonObject;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCraftingInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MechanicalCraftingRecipe
extends ShapedRecipe {
    private boolean acceptMirrored;

    public MechanicalCraftingRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn, boolean acceptMirrored) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.acceptMirrored = acceptMirrored;
    }

    private static MechanicalCraftingRecipe fromShaped(ShapedRecipe recipe, boolean acceptMirrored) {
        return new MechanicalCraftingRecipe(recipe.func_199560_c(), recipe.func_193358_e(), recipe.func_192403_f(), recipe.func_192404_g(), (NonNullList<Ingredient>)recipe.func_192400_c(), recipe.func_77571_b(), acceptMirrored);
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!(inv instanceof MechanicalCraftingInventory)) {
            return false;
        }
        if (this.acceptsMirrored()) {
            return super.func_77569_a(inv, worldIn);
        }
        for (int i = 0; i <= inv.func_174922_i() - this.func_192403_f(); ++i) {
            for (int j = 0; j <= inv.func_174923_h() - this.func_192404_g(); ++j) {
                if (!this.matchesSpecific(inv, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesSpecific(CraftingInventory inv, int p_77573_2_, int p_77573_3_) {
        NonNullList ingredients = this.func_192400_c();
        int width = this.func_192403_f();
        int height = this.func_192404_g();
        for (int i = 0; i < inv.func_174922_i(); ++i) {
            for (int j = 0; j < inv.func_174923_h(); ++j) {
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < width && l < height) {
                    ingredient = (Ingredient)ingredients.get(k + l * width);
                }
                if (ingredient.test(inv.func_70301_a(i + j * inv.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public IRecipeType<?> func_222127_g() {
        return AllRecipeTypes.MECHANICAL_CRAFTING.getType();
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return AllRecipeTypes.MECHANICAL_CRAFTING.getSerializer();
    }

    public boolean acceptsMirrored() {
        return this.acceptMirrored;
    }

    public static class Serializer
    extends ShapedRecipe.Serializer {
        public ShapedRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            return MechanicalCraftingRecipe.fromShaped(super.func_199425_a_(recipeId, json), JSONUtils.func_151209_a((JsonObject)json, (String)"acceptMirrored", (boolean)true));
        }

        public ShapedRecipe func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            return MechanicalCraftingRecipe.fromShaped(super.func_199426_a_(recipeId, buffer), buffer.readBoolean() && buffer.readBoolean());
        }

        public void func_199427_a_(PacketBuffer p_199427_1_, ShapedRecipe p_199427_2_) {
            super.func_199427_a_(p_199427_1_, p_199427_2_);
            if (p_199427_2_ instanceof MechanicalCraftingRecipe) {
                p_199427_1_.writeBoolean(true);
                p_199427_1_.writeBoolean(((MechanicalCraftingRecipe)p_199427_2_).acceptsMirrored());
            } else {
                p_199427_1_.writeBoolean(false);
            }
        }
    }
}

