/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.mixin;

import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.perk.node.key.KeyMagnetDrops;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.loot.LootUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.LogicalSide;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mixin(value={ForgeHooks.class})
public class MixinForgeHooks {
    @Inject(method={"modifyLoot(Lnet/minecraft/util/ResourceLocation;Ljava/util/List;Lnet/minecraft/loot/LootContext;)Ljava/util/List;"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void runLootTeleportation(ResourceLocation lootTableId, List<ItemStack> generatedLoot, LootContext context, CallbackInfoReturnable<List<ItemStack>> cir) {
        int curiosFortuneBonus;
        List loot = (List)cir.getReturnValue();
        if (!LootUtil.doesContextFulfillSet(context, LootParameterSets.field_216267_h)) {
            return;
        }
        Entity e = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (!(e instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)e;
        PlayerProgress prog = ResearchHelper.getProgress(player, LogicalSide.SERVER);
        if (!prog.isValid() || !prog.getPerkData().hasPerkEffect(perk -> perk instanceof KeyMagnetDrops)) {
            return;
        }
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (tool != null && tool.func_77942_o() && tool.func_77978_p().func_74764_b("HasCuriosFortuneBonus")) {
            loot.removeIf(result -> ItemUtils.dropItemToPlayer(player, result).func_190926_b());
        }
        if ((curiosFortuneBonus = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(ICuriosItemHandler::getFortuneBonus).orElse(0).intValue()) > 0) {
            return;
        }
        loot.removeIf(result -> ItemUtils.dropItemToPlayer(player, result).func_190926_b());
    }
}

