/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.sound;

import hellfirepvp.astralsorcery.client.util.sound.FadeLoopSound;
import hellfirepvp.astralsorcery.client.util.sound.FadeSound;
import hellfirepvp.astralsorcery.client.util.sound.PositionedLoopSound;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.sound.CategorizedSoundEvent;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoundHelper {
    public static void playSoundAround(SoundEvent sound, World world, Vector3i position, float volume, float pitch) {
        SoundHelper.playSoundAround(sound, SoundCategory.MASTER, world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), volume, pitch);
    }

    public static void playSoundAround(SoundEvent sound, SoundCategory category, World world, Vector3i position, float volume, float pitch) {
        SoundHelper.playSoundAround(sound, category, world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), volume, pitch);
    }

    public static void playSoundAround(SoundEvent sound, World world, Vector3 position, float volume, float pitch) {
        SoundHelper.playSoundAround(sound, SoundCategory.MASTER, world, position.getX(), position.getY(), position.getZ(), volume, pitch);
    }

    public static void playSoundAround(SoundEvent sound, SoundCategory category, World world, Vector3 position, float volume, float pitch) {
        SoundHelper.playSoundAround(sound, category, world, position.getX(), position.getY(), position.getZ(), volume, pitch);
    }

    public static void playSoundAround(SoundEvent sound, SoundCategory category, World world, double posX, double posY, double posZ, float volume, float pitch) {
        if (sound instanceof CategorizedSoundEvent) {
            category = ((CategorizedSoundEvent)sound).getCategory();
        }
        world.func_184148_a(null, posX, posY, posZ, sound, category, volume, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PositionedLoopSound playSoundLoopClient(SoundEvent sound, Vector3 pos, float volume, float pitch, boolean isGlobal, Predicate<PositionedLoopSound> func) {
        SoundCategory cat = SoundCategory.MASTER;
        if (sound instanceof CategorizedSoundEvent) {
            cat = ((CategorizedSoundEvent)sound).getCategory();
        }
        PositionedLoopSound posSound = new PositionedLoopSound(sound, cat, volume, pitch, pos, isGlobal);
        posSound.setRefreshFunction(func);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)posSound);
        return posSound;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FadeLoopSound playSoundLoopFadeInClient(SoundEvent sound, Vector3 pos, float volume, float pitch, boolean isGlobal, Predicate<PositionedLoopSound> func) {
        SoundCategory cat = SoundCategory.MASTER;
        if (sound instanceof CategorizedSoundEvent) {
            cat = ((CategorizedSoundEvent)sound).getCategory();
        }
        FadeLoopSound posSound = new FadeLoopSound(sound, cat, volume, pitch, pos, isGlobal);
        posSound.setRefreshFunction(func);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)posSound);
        return posSound;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FadeSound playSoundFadeInClient(SoundEvent sound, Vector3 pos, float volume, float pitch, boolean isGlobal, Predicate<FadeSound> func) {
        SoundCategory cat = SoundCategory.MASTER;
        if (sound instanceof CategorizedSoundEvent) {
            cat = ((CategorizedSoundEvent)sound).getCategory();
        }
        FadeSound posSound = new FadeSound(sound, cat, volume, pitch, pos, isGlobal);
        posSound.setRefreshFunction(func);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)posSound);
        return posSound;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getSoundVolume(SoundCategory cat) {
        return Minecraft.func_71410_x().field_71474_y.func_186711_a(cat);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundClient(SoundEvent sound, float volume, float pitch) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            player.func_184185_a(sound, volume, pitch);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundClientWorld(CategorizedSoundEvent sound, BlockPos pos, float volume, float pitch) {
        SoundHelper.playSoundClientWorld(sound, sound.getCategory(), pos, volume, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundClientWorld(SoundEvent sound, SoundCategory cat, BlockPos pos, float volume, float pitch) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Minecraft.func_71410_x().field_71441_e.func_184148_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), sound, cat, volume, pitch);
        }
    }
}

