/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.network;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectStatus;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.CrystalCalculations;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.starlight.transmission.base.SimpleTransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.TransmissionProvider;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.PartialEffectExecutor;
import hellfirepvp.astralsorcery.common.util.RaytraceAssist;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.world.SkyCollectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class StarlightReceiverRitualPedestal
extends SimpleTransmissionReceiver<TileRitualPedestal> {
    private static final Random rand = new Random();
    private final Map<BlockPos, Boolean> offsetMirrors = new HashMap<BlockPos, Boolean>();
    private boolean doesSeeSky = false;
    private boolean hasMultiblock = false;
    private IWeakConstellation channelingType = null;
    private IMinorConstellation channelingTrait = null;
    private CrystalAttributes attributes = null;
    private BlockPos ritualLinkPos = null;
    private int ticksExisted = 0;
    private ConstellationEffect effect = null;
    private double collectedStarlight = 0.0;
    private float noiseDistribution = -1.0f;

    public StarlightReceiverRitualPedestal(BlockPos thisPos) {
        super(thisPos);
    }

    @Override
    public void update(World world) {
        super.update(world);
        ++this.ticksExisted;
        if (!this.hasMultiblock || this.channelingType == null || this.attributes == null) {
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.validateMirrorPositions(world);
        }
        if (this.doesSeeSky) {
            this.collectStarlight(world);
        }
        if (this.effect != null && this.collectedStarlight > 0.0) {
            this.doRitualEffect(world);
        }
    }

    private void doRitualEffect(World world) {
        ConstellationEffectProperties properties = this.effect.createProperties(this.getMirrorCount());
        if (this.channelingTrait != null) {
            this.channelingTrait.affectConstellationEffect(properties);
        }
        properties.multiplySize(CrystalCalculations.getRitualEffectRangeFactor(this, this.attributes));
        float maxDrain = 12.0f;
        maxDrain = (float)((double)maxDrain * CrystalCalculations.getRitualCostReductionFactor(this, this.attributes));
        float ritualStrength = (float)this.collectedStarlight / (maxDrain /= Math.max(1.0f, (float)(this.getMirrorCount() - 1) * 0.33f));
        BlockPos to = this.getLocationPos();
        if (this.ritualLinkPos != null) {
            to = this.ritualLinkPos;
        }
        if (this.effect instanceof ConstellationEffectStatus && this.collectedStarlight > 0.0) {
            this.collectedStarlight = 0.0;
            if (((Boolean)this.effect.getConfig().enabled.get()).booleanValue() && ((ConstellationEffectStatus)((Object)this.effect)).runStatusEffect(world, to, this.getMirrorCount(), properties, this.channelingTrait)) {
                this.markDirty(world);
            }
            return;
        }
        float max = 10.0f * properties.getEffectAmplifier();
        float stretch = 10.0f / properties.getPotency();
        float executeTimes = (float)Math.atan(ritualStrength / stretch) * max;
        if (properties.isCorrupted()) {
            executeTimes = (float)((double)executeTimes * Math.max(rand.nextDouble() * 1.4, 0.1));
        }
        PartialEffectExecutor exec = new PartialEffectExecutor(executeTimes, rand);
        while (exec.canExecute()) {
            boolean didEffectExecute;
            exec.markExecution();
            if (!((Boolean)this.effect.getConfig().enabled.get()).booleanValue() || !(didEffectExecute = this.effect.needsChunkToBeLoaded() ? MiscUtils.executeWithChunk((IWorldReader)world, to, to, pos -> this.effect.playEffect(world, (BlockPos)pos, properties, this.channelingTrait), false).booleanValue() : this.effect.playEffect(world, to, properties, this.channelingTrait))) continue;
            this.markDirty(world);
        }
        this.collectedStarlight = 0.0;
    }

    private void collectStarlight(World world) {
        WorldContext ctx = SkyHandler.getContext(world, LogicalSide.SERVER);
        if (ctx == null) {
            return;
        }
        double collected = 1.3;
        collected *= 0.25 + 0.75 * (double)DayTimeHelper.getCurrentDaytimeDistribution(world);
        if (this.noiseDistribution == -1.0f) {
            this.noiseDistribution = world instanceof ISeedReader ? SkyCollectionHelper.getSkyNoiseDistribution((ISeedReader)world, this.getLocationPos()) : 0.3f;
        }
        collected *= (double)CrystalCalculations.getCrystalCollectionRate(this.attributes);
        collected *= (double)(0.4f + 0.6f * ctx.getDistributionHandler().getDistribution(this.channelingType));
        this.collectedStarlight += (collected *= (double)(1.0f + 0.5f * this.noiseDistribution));
    }

    @Override
    public void onStarlightReceive(World world, IWeakConstellation type, double amount) {
        if (this.channelingType != null && this.hasMultiblock && this.channelingType.equals(type)) {
            this.collectedStarlight += amount / 2.0;
            this.findNextMirror(world);
        }
    }

    @Override
    public boolean syncTileData(World world, TileRitualPedestal tile) {
        tile.setReceiverData(this.effect != null, this.offsetMirrors, this.attributes);
        this.markDirty(world);
        return true;
    }

    @Override
    public <T extends TileEntity> boolean updateFromTileEntity(T tile) {
        if (!(tile instanceof TileRitualPedestal)) {
            return super.updateFromTileEntity(tile);
        }
        TileRitualPedestal trp = (TileRitualPedestal)tile;
        if (this.channelingType != trp.getRitualConstellation() || this.attributes != null && trp.getAttributes() == null || this.hasMultiblock != trp.hasMultiblock()) {
            this.effect = null;
            this.offsetMirrors.clear();
            if (trp.isWorking() || !trp.getMirrors().isEmpty()) {
                this.markForTileSync();
            }
        }
        boolean ritualLinkChanged = this.ritualLinkPos == null ? trp.getRitualLinkTo() != null : !this.ritualLinkPos.equals((Object)trp.getRitualLinkTo());
        this.doesSeeSky = trp.doesSeeSky();
        this.hasMultiblock = trp.hasMultiblock();
        this.channelingType = trp.getRitualConstellation();
        this.channelingTrait = trp.getRitualTrait();
        this.attributes = trp.getAttributes();
        this.ritualLinkPos = trp.getRitualLinkTo();
        if (this.channelingType != null && this.attributes != null && this.hasMultiblock && (this.effect == null || ritualLinkChanged)) {
            this.effect = ConstellationEffectRegistry.createInstance(this, this.channelingType);
            this.markForTileSync();
        }
        if (!this.hasMultiblock || this.effect == null) {
            this.collectedStarlight = 0.0;
        }
        this.markDirty(trp.func_145831_w());
        return super.updateFromTileEntity(tile);
    }

    @Override
    public Class<TileRitualPedestal> getTileClass() {
        return TileRitualPedestal.class;
    }

    private void findNextMirror(World world) {
        if (this.offsetMirrors.size() >= 5 || this.effect == null || this.channelingType == null) {
            return;
        }
        long seed = 3451968351053166105L;
        seed |= this.getLocationPos().func_218275_a() * 31L;
        Random r = new Random(seed |= (long)(this.channelingType.getSimpleName().hashCode() * 31));
        for (int i = 0; i < this.getMirrorCount(); ++i) {
            r.nextInt(TileRitualPedestal.RITUAL_CIRCLE_OFFSETS.size());
        }
        BlockPos offset = null;
        int c = 100;
        block1: while (offset == null && c > 0) {
            --c;
            BlockPos test = MiscUtils.getRandomEntry(TileRitualPedestal.RITUAL_CIRCLE_OFFSETS, r);
            RaytraceAssist ray = new RaytraceAssist(this.getLocationPos(), this.getLocationPos().func_177971_a((Vector3i)test));
            Vector3 from = new Vector3(0.5, 0.7, 0.5);
            Vector3 newDir = new Vector3((Vector3i)test).add(0.5, 0.5, 0.5).subtract(from);
            for (BlockPos p : this.offsetMirrors.keySet()) {
                Vector3 toDir = new Vector3((Vector3i)p).add(0.5, 0.5, 0.5).subtract(from);
                if (!(Math.toDegrees(toDir.angle(newDir)) <= 30.0) && !(from.distanceSquared(Vector3d.func_237489_a_((Vector3i)p)) <= 3.0)) continue;
                continue block1;
            }
            if (!ray.isClear(world)) continue;
            offset = test;
        }
        if (offset != null) {
            this.offsetMirrors.put(offset, false);
            this.markForTileSync();
            this.markDirty(world);
        }
    }

    private void validateMirrorPositions(World world) {
        WorldNetworkHandler handle = WorldNetworkHandler.getNetworkHandler(world);
        List<BlockPos> srcLinkingToThis = this.getSources();
        boolean needsUpdate = false;
        for (BlockPos pos : new ArrayList<BlockPos>(this.offsetMirrors.keySet())) {
            BlockPos actualPos = this.getLocationPos().func_177971_a((Vector3i)pos);
            boolean existingFlag = this.offsetMirrors.get(pos);
            if (!srcLinkingToThis.contains(actualPos)) {
                this.offsetMirrors.put(pos, false);
                if (!existingFlag) continue;
                needsUpdate = true;
                continue;
            }
            IPrismTransmissionNode other = handle.getTransmissionNode(actualPos);
            if (other == null) continue;
            boolean foundLink = false;
            for (NodeConnection<IPrismTransmissionNode> n : other.queryNext(handle)) {
                if (!n.getTo().equals((Object)this.getLocationPos())) continue;
                boolean connect = n.canConnect();
                this.offsetMirrors.put(pos, connect);
                if (connect != existingFlag) {
                    needsUpdate = true;
                }
                foundLink = true;
                break;
            }
            if (foundLink) continue;
            this.offsetMirrors.put(pos, false);
            if (!existingFlag) continue;
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.markForTileSync();
        }
    }

    private int getMirrorCount() {
        return (int)this.offsetMirrors.values().stream().filter(b -> b).count();
    }

    @Nullable
    public IWeakConstellation getChannelingType() {
        return this.channelingType;
    }

    @Nullable
    public IMinorConstellation getChannelingTrait() {
        return this.channelingTrait;
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    @Override
    public TransmissionProvider getProvider() {
        return new Provider();
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        super.readFromNBT(compound);
        this.doesSeeSky = compound.func_74767_n("doesSeeSky");
        this.hasMultiblock = compound.func_74767_n("hasMultiblock");
        this.ticksExisted = compound.func_74762_e("ticksExisted");
        this.collectedStarlight = compound.func_74769_h("collectedStarlight");
        IConstellation channeling = IConstellation.readFromNBT(compound, "channelingType");
        this.channelingType = channeling instanceof IWeakConstellation ? (IWeakConstellation)channeling : null;
        IConstellation trait = IConstellation.readFromNBT(compound, "channelingTrait");
        this.channelingTrait = trait instanceof IMinorConstellation ? (IMinorConstellation)trait : null;
        this.attributes = CrystalAttributes.getCrystalAttributes(compound);
        this.ritualLinkPos = compound.func_74764_b("ritualLinkPos") ? NBTHelper.readBlockPosFromNBT(compound.func_74775_l("ritualLinkPos")) : null;
        this.offsetMirrors.clear();
        ListNBT tagList = compound.func_150295_c("mirrors", 10);
        for (INBT nbt : tagList) {
            CompoundNBT tag = (CompoundNBT)nbt;
            this.offsetMirrors.put(NBTHelper.readBlockPosFromNBT(tag), tag.func_74767_n("connect"));
        }
        if (this.channelingType != null) {
            this.effect = ConstellationEffectRegistry.createInstance(this, this.channelingType);
            if (this.effect != null && compound.func_74764_b("effect")) {
                this.effect.readFromNBT(compound.func_74775_l("effect"));
            }
        }
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        super.writeToNBT(compound);
        compound.func_74757_a("doesSeeSky", this.doesSeeSky);
        compound.func_74757_a("hasMultiblock", this.hasMultiblock);
        compound.func_74768_a("ticksExisted", this.ticksExisted);
        compound.func_74780_a("collectedStarlight", this.collectedStarlight);
        if (this.channelingType != null) {
            this.channelingType.writeToNBT(compound, "channelingType");
        }
        if (this.channelingTrait != null) {
            this.channelingTrait.writeToNBT(compound, "channelingTrait");
        }
        if (this.attributes != null) {
            this.attributes.store(compound);
        }
        if (this.ritualLinkPos != null) {
            compound.func_218657_a("ritualLinkPos", (INBT)NBTHelper.writeBlockPosToNBT(this.ritualLinkPos, new CompoundNBT()));
        }
        ListNBT listPositions = new ListNBT();
        for (Map.Entry<BlockPos, Boolean> posEntry : this.offsetMirrors.entrySet()) {
            CompoundNBT cmp = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(posEntry.getKey(), cmp);
            cmp.func_74757_a("connect", posEntry.getValue().booleanValue());
            listPositions.add((Object)cmp);
        }
        compound.func_218657_a("mirrors", (INBT)listPositions);
        if (this.channelingType != null && this.effect != null) {
            NBTHelper.setAsSubTag(compound, "effect", this.effect::writeToNBT);
        }
    }

    public static class Provider
    extends TransmissionProvider {
        @Override
        public IPrismTransmissionNode get() {
            return new StarlightReceiverRitualPedestal(null);
        }
    }
}

