/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXMotionController;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.block.tile.BlockSpectralRelay;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.item.ItemGlassLens;
import hellfirepvp.astralsorcery.common.lib.StructureTypesAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.structure.types.StructureType;
import hellfirepvp.astralsorcery.common.tile.altar.AltarCollectionCategory;
import hellfirepvp.astralsorcery.common.tile.altar.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileEntitySynchronized;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.tile.TileInventory;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileSpectralRelay
extends TileEntityTick {
    private TileInventory inventory = new TileInventory((TileEntitySynchronized)this, () -> 1, new Direction[0]);
    private BlockPos altarPos;
    private BlockPos closestRelayPos;
    private float proximityMultiplier = 1.0f;

    public TileSpectralRelay() {
        super(TileEntityTypesAS.SPECTRAL_RELAY);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().func_201670_d()) {
            ItemStack in;
            if (!this.func_145831_w().func_175623_d(this.func_174877_v().func_177984_a()) && !(in = this.getInventory().getStackInSlot(0)).func_190926_b()) {
                ItemStack out = ItemUtils.copyStackWithSize(in, in.func_190916_E());
                ItemUtils.dropItem(this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), out);
                this.getInventory().setStackInSlot(0, ItemStack.field_190927_a);
            }
            if (this.hasMultiblock() && this.hasGlassLens() && this.altarPos != null) {
                MiscUtils.executeWithChunk((IWorldReader)this.func_145831_w(), this.altarPos, () -> {
                    TileAltar ta = MiscUtils.getTileAt((IBlockReader)this.func_145831_w(), this.altarPos, TileAltar.class, true);
                    if (ta == null) {
                        this.updateAltarLinkState();
                    } else {
                        this.provideStarlight(ta);
                    }
                });
            }
        } else if (this.hasMultiblock() && this.hasGlassLens()) {
            this.playStructureParticles();
            if (this.altarPos != null && this.doesSeeSky()) {
                this.playAltarParticles();
            }
        }
    }

    @Override
    protected void onFirstTick() {
        this.updateRelayProximity();
    }

    public static void cascadeRelayProximityUpdates(World world, BlockPos pos) {
        if (world.func_201670_d()) {
            return;
        }
        TileSpectralRelay.foreachNearbyRelay(world, pos, TileSpectralRelay::updateRelayProximity);
    }

    private void updateRelayProximity() {
        if (this.func_145831_w().func_201670_d() || !this.hasGlassLens()) {
            return;
        }
        this.setClosestRelayPos(null);
        BlockPos thisPos = this.func_174877_v();
        Vector3d thisVPos = Vector3d.func_237491_b_((Vector3i)thisPos);
        TileSpectralRelay.foreachNearbyRelay(this.func_145831_w(), thisPos, relay -> {
            BlockPos relayPos = relay.func_174877_v();
            if (relayPos.equals((Object)thisPos)) {
                return;
            }
            Vector3d relayVPos = Vector3d.func_237491_b_((Vector3i)relayPos);
            BlockPos otherClosestPos = relay.closestRelayPos;
            if (otherClosestPos == null || thisPos.func_218138_a((IPosition)relayVPos, false) < otherClosestPos.func_218138_a((IPosition)relayVPos, false)) {
                relay.setClosestRelayPos(thisPos);
            }
            if (this.closestRelayPos == null || relayPos.func_218138_a((IPosition)thisVPos, false) < this.closestRelayPos.func_218138_a((IPosition)thisVPos, false)) {
                this.setClosestRelayPos(relayPos);
            }
        });
    }

    private static void foreachNearbyRelay(World world, BlockPos pos, Consumer<TileSpectralRelay> relayConsumer) {
        List<BlockPos> nearbyRelays = BlockDiscoverer.searchForBlocksAround(world, pos, 8, (world1, pos1, state) -> {
            TileSpectralRelay relay;
            return state.func_177230_c() instanceof BlockSpectralRelay && (relay = MiscUtils.getTileAt((IBlockReader)world1, pos1, TileSpectralRelay.class, false)) != null && relay.hasGlassLens() && relay.hasMultiblock();
        });
        nearbyRelays.forEach(relayPos -> {
            TileSpectralRelay relay = MiscUtils.getTileAt((IBlockReader)world, relayPos, TileSpectralRelay.class, false);
            if (relay != null) {
                relayConsumer.accept(relay);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playAltarParticles() {
        Vector3 pos = new Vector3(this).add(0.5, 0.35, 0.5);
        Vector3 target = new Vector3((Vector3i)this.altarPos).add(0.5, 0.5, 0.5);
        int maxAge = 30;
        maxAge = (int)((double)maxAge * Math.max(pos.distance(target) / 3.0, 1.0));
        EntityVisualFX vfx = (EntityVisualFX)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.proximity(target::clone, 2.0f).andThen(VFXAlphaFunction.FADE_OUT))).motion(VFXMotionController.target(target::clone, 0.08f))).setMotion(Vector3.random().normalize().multiply(0.1f + rand.nextFloat() * 0.05f))).setScaleMultiplier(0.15f + rand.nextFloat() * 0.05f)).setMaxAge(maxAge);
        if (rand.nextBoolean()) {
            vfx.color(VFXColorFunction.WHITE);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playStructureParticles() {
        if (rand.nextBoolean()) {
            Vector3 pos = new Vector3(this).add(0.5, 0.0, 0.5);
            Vector3 offset = new Vector3(0, 0, 0);
            MiscUtils.applyRandomOffset(offset, rand, 1.25f);
            pos.add(offset.getX(), 0.0, offset.getZ());
            EntityVisualFX vfx = (EntityVisualFX)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(pos)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.15f + rand.nextFloat() * 0.1f)).setGravityStrength(-0.001f)).setMaxAge(30 + rand.nextInt(20));
            if (rand.nextBoolean()) {
                vfx.color(VFXColorFunction.WHITE);
            }
        }
    }

    private void provideStarlight(TileAltar ta) {
        if (this.doesSeeSky()) {
            float heightAmount = MathHelper.func_76131_a((float)((float)Math.pow((float)this.func_174877_v().func_177956_o() / 7.0f, 1.5) / 60.0f), (float)0.0f, (float)1.0f);
            heightAmount = 0.7f + heightAmount * 0.3f;
            heightAmount *= DayTimeHelper.getCurrentDaytimeDistribution(this.func_145831_w());
            if ((double)(heightAmount *= this.proximityMultiplier) > 1.0E-4) {
                ta.collectStarlight(heightAmount * 45.0f, AltarCollectionCategory.RELAY);
            }
        }
    }

    @Override
    @Nullable
    public StructureType getRequiredStructureType() {
        if (this.hasGlassLens()) {
            return StructureTypesAS.PTYPE_SPECTRAL_RELAY;
        }
        return null;
    }

    @Override
    protected void notifyMultiblockStateUpdate(boolean hadMultiblockPrev, boolean hasMultiblockNow) {
        if (!hasMultiblockNow && this.altarPos != null) {
            this.altarPos = null;
        }
        if (hasMultiblockNow && this.hasGlassLens()) {
            this.updateAltarPos();
        }
    }

    public void updateAltarLinkState() {
        if (!this.hasGlassLens() || !this.hasMultiblock()) {
            this.altarPos = null;
            this.markForUpdate();
            return;
        }
        this.updateAltarPos();
    }

    private void updateAltarPos() {
        Set<BlockPos> altarPositions = BlockDiscoverer.searchForTileEntitiesAround(this.func_145831_w(), this.func_174877_v(), 16, tile -> tile instanceof TileAltar);
        Vector3d thisPos = Vector3d.func_237491_b_((Vector3i)this.func_174877_v());
        BlockPos closestAltar = null;
        for (BlockPos other : altarPositions) {
            if (closestAltar != null && !(other.func_218138_a((IPosition)thisPos, false) < closestAltar.func_218138_a((IPosition)thisPos, false))) continue;
            closestAltar = other;
        }
        this.altarPos = closestAltar;
        this.markForUpdate();
    }

    private void setClosestRelayPos(@Nullable BlockPos closestRelayPos) {
        this.closestRelayPos = closestRelayPos;
        this.markForUpdate();
        this.proximityMultiplier = this.closestRelayPos == null ? 1.0f : MathHelper.func_76131_a((float)((float)new Vector3((Vector3i)this.func_174877_v()).distance((Vector3i)this.closestRelayPos) / 8.0f), (float)0.0f, (float)1.0f);
    }

    public boolean hasGlassLens() {
        return this.getInventory().getStackInSlot(0).func_77973_b() instanceof ItemGlassLens;
    }

    @Nonnull
    public TileInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.inventory = this.inventory.deserialize(compound.func_74775_l("inventory"));
        this.altarPos = compound.func_74764_b("altarPos") ? NBTHelper.readBlockPosFromNBT(compound.func_74775_l("altarPos")) : null;
        if (compound.func_74764_b("closestRelayPos")) {
            this.setClosestRelayPos(NBTHelper.readBlockPosFromNBT(compound.func_74775_l("closestRelayPos")));
        } else {
            this.setClosestRelayPos(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serialize());
        if (this.altarPos != null) {
            compound.func_218657_a("altarPos", (INBT)NBTHelper.writeBlockPosToNBT(this.altarPos, new CompoundNBT()));
        }
        if (this.closestRelayPos != null) {
            compound.func_218657_a("closestRelayPos", (INBT)NBTHelper.writeBlockPosToNBT(this.closestRelayPos, new CompoundNBT()));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.inventory.hasCapability(cap, side)) {
            return this.inventory.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }
}

