/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.transmission.base.crystal;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.crystal.CrystalCalculations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.registry.SourceClassRegistry;
import hellfirepvp.astralsorcery.common.tile.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.world.SkyCollectionHelper;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;

public class IndependentCrystalSource
implements IIndependentStarlightSource {
    public static final double MIN_DST = 16.0;
    private IWeakConstellation constellation = null;
    private CrystalAttributes crystalAttributes = null;
    private boolean doesSeeSky = false;
    private boolean doesAutoLink = false;
    private double collectionDstMultiplier = 1.0;
    private BlockPos closestOtherCollector = null;
    private float posDistribution = -1.0f;
    private boolean enhanced = false;

    @Override
    public float produceStarlightTick(ServerWorld world, BlockPos pos) {
        if (!this.doesSeeSky || this.crystalAttributes == null) {
            return 0.0f;
        }
        IWeakConstellation cst = this.getStarlightType();
        WorldContext ctx = SkyHandler.getContext((World)world, LogicalSide.SERVER);
        if (ctx == null || cst == null) {
            return 0.0f;
        }
        if (this.posDistribution == -1.0f) {
            this.posDistribution = SkyCollectionHelper.getSkyNoiseDistribution((ISeedReader)world, pos);
        }
        if (this.closestOtherCollector != null && rand.nextInt(40) == 0) {
            PktPlayEffect pkt = new PktPlayEffect(PktPlayEffect.Type.LIGHTNING).addData(buf -> {
                ByteBufUtils.writeVector(buf, new Vector3((Vector3i)pos).add(0.5, 0.5, 0.5));
                ByteBufUtils.writeVector(buf, new Vector3((Vector3i)this.closestOtherCollector).add(0.5, 0.5, 0.5));
                buf.writeInt(this.constellation.getConstellationColor().darker().getRGB());
            });
            PacketChannel.CHANNEL.sendToAllAround(pkt, PacketChannel.pointFromPos((World)world, (Vector3i)pos, 32.0));
        }
        Function<Float, Float> distrFunction = this.getDistributionFunc();
        float perc = CrystalCalculations.getCollectorCrystalCollectionRate(this);
        perc *= distrFunction.apply(Float.valueOf(0.3f + 0.7f * DayTimeHelper.getCurrentDaytimeDistribution((World)world))).floatValue();
        perc = (float)((double)perc * this.collectionDstMultiplier);
        perc = (float)((double)perc * (1.0 + 0.3 * (double)this.posDistribution));
        perc = (float)((double)perc * (0.4 + 0.6 * (double)ctx.getDistributionHandler().getDistribution(cst)));
        return perc;
    }

    private Function<Float, Float> getDistributionFunc() {
        if (this.enhanced) {
            return in -> Float.valueOf(0.6f + 0.5f * in.floatValue());
        }
        return in -> Float.valueOf(0.2f + 0.8f * in.floatValue());
    }

    @Override
    public boolean providesAutoLink() {
        return this.doesAutoLink;
    }

    @Override
    public <T extends TileEntity> boolean updateFromTileEntity(T tile) {
        if (!(tile instanceof TileCollectorCrystal)) {
            return true;
        }
        TileCollectorCrystal tcc = (TileCollectorCrystal)tile;
        this.doesSeeSky = tcc.doesSeeSky();
        this.doesAutoLink = !tcc.isPlayerMade();
        this.enhanced = tcc.isEnhanced();
        this.constellation = tcc.getAttunedConstellation();
        this.crystalAttributes = tcc.getAttributes();
        return true;
    }

    @Override
    public void threadedUpdateProximity(BlockPos thisPos, Map<BlockPos, IIndependentStarlightSource> otherSources) {
        double minDstSq = Double.MAX_VALUE;
        BlockPos closest = null;
        for (BlockPos other : otherSources.keySet()) {
            double dstSq;
            if (other.equals((Object)thisPos) || !((dstSq = thisPos.func_218138_a((IPosition)Vector3d.func_237491_b_((Vector3i)other), false)) < minDstSq)) continue;
            minDstSq = dstSq;
            closest = other;
        }
        double dst = Math.sqrt(minDstSq);
        if (dst <= 16.0) {
            this.collectionDstMultiplier = dst / 16.0;
            this.closestOtherCollector = closest;
        } else {
            this.collectionDstMultiplier = 1.0;
            this.closestOtherCollector = null;
        }
    }

    public CrystalAttributes getCrystalAttributes() {
        return this.crystalAttributes;
    }

    @Override
    @Nullable
    public IWeakConstellation getStarlightType() {
        return this.constellation;
    }

    @Override
    public SourceClassRegistry.SourceProvider getProvider() {
        return new Provider();
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        this.constellation = NBTHelper.readOptional(compound, "constellation", nbt -> {
            IConstellation cst = IConstellation.readFromNBT(nbt);
            if (cst instanceof IWeakConstellation) {
                return (IWeakConstellation)cst;
            }
            return null;
        });
        this.crystalAttributes = CrystalAttributes.getCrystalAttributes(compound);
        this.doesSeeSky = compound.func_74767_n("doesSeeSky");
        this.doesAutoLink = compound.func_74767_n("doesAutoLink");
        this.collectionDstMultiplier = compound.func_74769_h("collectionDstMultiplier");
        this.closestOtherCollector = NBTHelper.readOptional(compound, "closestOtherCollector", NBTHelper::readBlockPosFromNBT);
        this.enhanced = compound.func_74767_n("enhanced");
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        if (this.crystalAttributes != null) {
            this.crystalAttributes.store(compound);
        }
        NBTHelper.writeOptional(compound, "constellation", this.constellation, (nbt, cst) -> cst.writeToNBT((CompoundNBT)nbt));
        compound.func_74757_a("doesSeeSky", this.doesSeeSky);
        compound.func_74757_a("doesAutoLink", this.doesAutoLink);
        compound.func_74780_a("collectionDstMultiplier", this.collectionDstMultiplier);
        NBTHelper.writeOptional(compound, "closestOtherCollector", this.closestOtherCollector, (nbt, pos) -> NBTHelper.writeBlockPosToNBT(pos, nbt));
        compound.func_74757_a("enhanced", this.enhanced);
    }

    public static class Provider
    implements SourceClassRegistry.SourceProvider {
        @Override
        public IIndependentStarlightSource provideEmptySource() {
            return new IndependentCrystalSource();
        }

        @Override
        @Nonnull
        public ResourceLocation getIdentifier() {
            return AstralSorcery.key("independent_crystal_source");
        }
    }
}

