/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;

public class StarlightTransmissionHandler
implements ITickHandler {
    private static final StarlightTransmissionHandler instance = new StarlightTransmissionHandler();
    private final Map<RegistryKey<World>, TransmissionWorldHandler> worldHandlers = new HashMap<RegistryKey<World>, TransmissionWorldHandler>();

    private StarlightTransmissionHandler() {
    }

    public static StarlightTransmissionHandler getInstance() {
        return instance;
    }

    public void tick(TickEvent.Type type, Object ... context) {
        World world = (World)context[0];
        if (world.func_201670_d() || !(world instanceof ServerWorld)) {
            return;
        }
        this.worldHandlers.computeIfAbsent((RegistryKey<World>)world.func_234923_W_(), TransmissionWorldHandler::new).tick((ServerWorld)world);
    }

    public void clearServer() {
        this.worldHandlers.values().forEach(TransmissionWorldHandler::clear);
        this.worldHandlers.clear();
    }

    public void informWorldUnload(World world) {
        RegistryKey dimKey = world.func_234923_W_();
        TransmissionWorldHandler handle = this.worldHandlers.get(dimKey);
        if (handle != null) {
            handle.clear();
        }
        this.worldHandlers.remove(dimKey);
    }

    @Nullable
    public TransmissionWorldHandler getWorldHandler(World world) {
        if (world == null) {
            return null;
        }
        return this.worldHandlers.get(world.func_234923_W_());
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.WORLD);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.START;
    }

    public String getName() {
        return "Starlight Transmission Handler";
    }
}

