/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node.key;

import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.node.KeyPerk;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class KeyCullingAttack
extends KeyPerk {
    private static final float defaultCullHealth = 0.15f;
    private static final int defaultChargeCost = 250;
    public static final Config CONFIG = new Config("key.culling");

    public KeyCullingAttack(ResourceLocation name, float x, float y) {
        super(name, x, y);
    }

    @Override
    public void attachListeners(LogicalSide side, IEventBus bus) {
        super.attachListeners(side, bus);
        bus.addListener(EventPriority.LOW, this::onDamage);
    }

    private void onDamage(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        if (source.func_76346_g() != null && source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            LogicalSide side = this.getSide((Entity)player);
            PlayerProgress prog = ResearchHelper.getProgress(player, side);
            if (side.isServer() && prog.getPerkData().hasPerkEffect(this)) {
                LivingEntity attacked = event.getEntityLiving();
                float actCull = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, ((Double)CONFIG.cullHealth.get()).floatValue());
                float lifePerc = attacked.func_110143_aJ() / attacked.func_110138_aP();
                if (lifePerc < actCull && AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)CONFIG.chargeCost.get()).intValue(), false)) {
                    attacked.func_70606_j(0.0f);
                    attacked.func_184212_Q().func_187227_b(LivingEntity.field_184632_c, (Object)Float.valueOf(0.0f));
                }
            }
        }
    }

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue cullHealth;
        private ForgeConfigSpec.IntValue chargeCost;

        private Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.cullHealth = cfgBuilder.comment("Defines the percentage at how low the entities' health as to be to then cull the entity.").translation(this.translationKey("cullHealth")).defineInRange("cullHealth", (double)0.15f, (double)0.05f, 0.5);
            this.chargeCost = cfgBuilder.comment("Defines the amount of starlight charge consumed per culling attempt.").translation(this.translationKey("chargeCost")).defineInRange("chargeCost", 250, 1, 500);
        }
    }
}

