/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.node;

import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.data.config.base.ConfigEntry;
import hellfirepvp.astralsorcery.common.perk.modifier.AttributeModifierPerk;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreeConstellation;
import hellfirepvp.astralsorcery.common.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.util.DiminishingMultiplier;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.LogicalSide;

public abstract class RootPerk
extends AttributeModifierPerk {
    private final IMajorConstellation constellation;
    private final Map<UUID, DiminishingMultiplier> dimReturns = new HashMap<UUID, DiminishingMultiplier>();
    private final Config config;

    public RootPerk(ResourceLocation name, Config rootConfig, IMajorConstellation constellation, float x, float y) {
        super(name, x, y);
        this.constellation = constellation;
        this.config = rootConfig;
        this.setCategory(CATEGORY_ROOT);
    }

    protected PerkTreePoint<? extends RootPerk> initPerkTreePoint() {
        return new PerkTreeConstellation<RootPerk>(this, this.getOffset(), this.constellation, 50);
    }

    public IMajorConstellation getConstellation() {
        return this.constellation;
    }

    @Override
    public void clearCaches(LogicalSide side) {
        super.clearCaches(side);
        if (side.isServer()) {
            this.dimReturns.clear();
        }
    }

    protected double getExpMultiplier() {
        return (Double)this.config.expMultiplier.get();
    }

    protected float getDiminishingReturns(PlayerEntity player) {
        UUID playerUUID = player.func_110124_au();
        return this.dimReturns.computeIfAbsent(playerUUID, uuid -> this.createMultiplier()).getMultiplier();
    }

    @Nonnull
    protected abstract DiminishingMultiplier createMultiplier();

    public static class Config
    extends ConfigEntry {
        private ForgeConfigSpec.DoubleValue expMultiplier;

        public Config(String section) {
            super(section);
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            this.expMultiplier = cfgBuilder.comment("Defines the general exp multiplier for this root perk. Can be used for balancing in a pack environment.").translation(this.translationKey("expMultiplier")).defineInRange("expMultiplier", 1.0, (double)0.1f, 20.0);
        }
    }
}

