/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integration.crt;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeGrid;
import hellfirepvp.astralsorcery.common.lib.RecipeTypesAS;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.astralsorcery.AltarManager")
public class AltarManager
implements IRecipeManager {
    @ZenCodeType.Method
    public void addRecipe(String name, String altarType, IItemStack output, IIngredient[][] ingredients, int duration, int starlightRequired) {
        name = this.fixRecipeName(name);
        if (Arrays.stream(AltarType.values()).map(Enum::name).noneMatch(s -> s.equalsIgnoreCase(altarType))) {
            throw new IllegalArgumentException("Unknown Astral Sorcery Altar Type: " + altarType);
        }
        if (ingredients.length != 5) {
            throw new IllegalArgumentException("Astral Sorcery Altar ingredients needs to be a 5x5 array with all values filled. Use <item:minecraft:air> to pad it out!");
        }
        for (IIngredient[] ingredient : ingredients) {
            if (ingredient.length == 5) continue;
            throw new IllegalArgumentException("Astral Sorcery Altar ingredients needs to be a 5x5 array with all values filled. Use <item:minecraft:air> to pad it out!");
        }
        AltarRecipeGrid.Builder builder = AltarRecipeGrid.builder();
        builder.patternLine("ABCDE").patternLine("FGHIJ").patternLine("KLMNO").patternLine("PQRST").patternLine("UVWXY");
        int index = 65;
        IIngredient[][] iIngredientArray = ingredients;
        int n = iIngredientArray.length;
        for (int i = 0; i < n; ++i) {
            IIngredient[] ingredient;
            for (IIngredient iIngredient : ingredient = iIngredientArray[i]) {
                builder.key(Character.valueOf((char)index), iIngredient.asVanillaIngredient());
                ++index;
            }
        }
        SimpleAltarRecipe recipe = new SimpleAltarRecipe(new ResourceLocation(name), AltarType.valueOf(altarType.toUpperCase()), duration, starlightRequired, builder.build());
        recipe.addOutput(output.getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, String altarType, IItemStack output, String[] pattern, Map<String, IIngredient> ingredients, int duration, int starlightRequired) {
        name = this.fixRecipeName(name);
        if (Arrays.stream(AltarType.values()).map(Enum::name).noneMatch(s -> s.equalsIgnoreCase(altarType))) {
            throw new IllegalArgumentException("Unknown Astral Sorcery Altar Type: " + altarType);
        }
        if (pattern.length != 5) {
            throw new IllegalArgumentException("Astral Sorcery Altar ingredients needs to be a 5x5 array with all values filled.");
        }
        if (ingredients.keySet().stream().anyMatch(s -> s.length() != 1)) {
            throw new IllegalArgumentException("Cannot have multiple characters as pattern key!");
        }
        AltarRecipeGrid.Builder builder = AltarRecipeGrid.builder();
        for (String strings : pattern) {
            builder.patternLine(strings);
        }
        for (String character : ingredients.keySet()) {
            builder.key(Character.valueOf(character.charAt(0)), ingredients.get(character).asVanillaIngredient());
        }
        SimpleAltarRecipe recipe = new SimpleAltarRecipe(new ResourceLocation(name), AltarType.valueOf(altarType.toUpperCase()), duration, starlightRequired, builder.build());
        recipe.addOutput(output.getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe));
    }

    public void removeRecipe(IItemStack output) {
        throw new UnsupportedOperationException("Cannot remove Altar recipes by their output, remove them by their name instead!");
    }

    public IRecipeType<SimpleAltarRecipe> getRecipeType() {
        return RecipeTypesAS.TYPE_ALTAR.getType();
    }
}

