/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integration;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.container.ContainerAltarAttunement;
import hellfirepvp.astralsorcery.common.container.ContainerAltarConstellation;
import hellfirepvp.astralsorcery.common.container.ContainerAltarDiscovery;
import hellfirepvp.astralsorcery.common.container.ContainerAltarTrait;
import hellfirepvp.astralsorcery.common.integration.jei.CategoryAltar;
import hellfirepvp.astralsorcery.common.integration.jei.CategoryInfuser;
import hellfirepvp.astralsorcery.common.integration.jei.CategoryLiquidInteraction;
import hellfirepvp.astralsorcery.common.integration.jei.CategoryTransmutation;
import hellfirepvp.astralsorcery.common.integration.jei.CategoryWell;
import hellfirepvp.astralsorcery.common.integration.jei.JEICategory;
import hellfirepvp.astralsorcery.common.integration.jei.TieredAltarRecipeTransferHandler;
import hellfirepvp.astralsorcery.common.item.ItemResonator;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class IntegrationJEI
implements IModPlugin {
    public static final List<JEICategory<?>> CATEGORIES = new ArrayList();
    public static final ResourceLocation CATEGORY_ALTAR_ATTUNEMENT = AstralSorcery.key("altar_attunement");
    public static final ResourceLocation CATEGORY_ALTAR_CONSTELLATION = AstralSorcery.key("altar_constellation");
    public static final ResourceLocation CATEGORY_ALTAR_DISCOVERY = AstralSorcery.key("altar_discovery");
    public static final ResourceLocation CATEGORY_ALTAR_TRAIT = AstralSorcery.key("altar_trait");
    public static final ResourceLocation CATEGORY_INFUSER = AstralSorcery.key("infuser");
    public static final ResourceLocation CATEGORY_LIQUID_INTERACTION = AstralSorcery.key("interaction");
    public static final ResourceLocation CATEGORY_TRANSMUTATION = AstralSorcery.key("transmutation");
    public static final ResourceLocation CATEGORY_WELL = AstralSorcery.key("well");
    public static IJeiRuntime runtime = null;

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        registry.useNbtForSubtypes(new Item[]{ItemsAS.ATTUNED_ROCK_CRYSTAL, ItemsAS.ATTUNED_CELESTIAL_CRYSTAL, Item.func_150898_a((Block)BlocksAS.ROCK_COLLECTOR_CRYSTAL), Item.func_150898_a((Block)BlocksAS.CELESTIAL_COLLECTOR_CRYSTAL), Item.func_150898_a((Block)BlocksAS.CELESTIAL_CRYSTAL_CLUSTER), Item.func_150898_a((Block)BlocksAS.GEM_CRYSTAL_CLUSTER)});
        registry.registerSubtypeInterpreter((Item)ItemsAS.RESONATOR, stack -> ItemResonator.getUpgrades(stack).stream().map(ItemResonator.ResonatorUpgrade::getAppendix).collect(Collectors.joining(",")));
        registry.registerSubtypeInterpreter((Item)ItemsAS.MANTLE, stack -> Optional.ofNullable(ItemsAS.MANTLE.getConstellation(stack)).map(IConstellation::getSimpleName).orElse("none"));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        if (CATEGORIES.isEmpty()) {
            CATEGORIES.add(new CategoryAltar(CATEGORY_ALTAR_DISCOVERY, "altar_discovery", BlocksAS.ALTAR_DISCOVERY, guiHelper));
            CATEGORIES.add(new CategoryAltar(CATEGORY_ALTAR_ATTUNEMENT, "altar_attunement", BlocksAS.ALTAR_ATTUNEMENT, guiHelper));
            CATEGORIES.add(new CategoryAltar(CATEGORY_ALTAR_CONSTELLATION, "altar_constellation", BlocksAS.ALTAR_CONSTELLATION, guiHelper));
            CATEGORIES.add(new CategoryAltar(CATEGORY_ALTAR_TRAIT, "altar_trait", BlocksAS.ALTAR_RADIANCE, guiHelper));
            CATEGORIES.add(new CategoryInfuser(guiHelper));
            CATEGORIES.add(new CategoryLiquidInteraction(guiHelper));
            CATEGORIES.add(new CategoryTransmutation(guiHelper));
            CATEGORIES.add(new CategoryWell(guiHelper));
        }
        CATEGORIES.forEach(xva$0 -> registry.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registry) {
        CATEGORIES.forEach(category -> {
            List recipes = category.getRecipes();
            recipes.sort(Comparator.comparing(recipe -> recipe.func_199560_c().toString()));
            registry.addRecipes(recipes, category.getUid());
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlocksAS.ALTAR_DISCOVERY), new ResourceLocation[]{CATEGORY_ALTAR_DISCOVERY});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlocksAS.ALTAR_ATTUNEMENT), new ResourceLocation[]{CATEGORY_ALTAR_ATTUNEMENT});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlocksAS.ALTAR_CONSTELLATION), new ResourceLocation[]{CATEGORY_ALTAR_CONSTELLATION});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlocksAS.ALTAR_RADIANCE), new ResourceLocation[]{CATEGORY_ALTAR_TRAIT});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlocksAS.INFUSER), new ResourceLocation[]{CATEGORY_INFUSER});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlocksAS.CHALICE), new ResourceLocation[]{CATEGORY_LIQUID_INTERACTION});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlocksAS.LENS), new ResourceLocation[]{CATEGORY_TRANSMUTATION});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlocksAS.WELL), new ResourceLocation[]{CATEGORY_WELL});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        IStackHelper stackHelper = registry.getJeiHelpers().getStackHelper();
        IRecipeTransferHandlerHelper transferHelper = registry.getTransferHelper();
        registry.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarDiscovery>(ContainerAltarDiscovery.class, stackHelper, transferHelper, 9), CATEGORY_ALTAR_DISCOVERY);
        registry.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarAttunement>(ContainerAltarAttunement.class, stackHelper, transferHelper, 13), CATEGORY_ALTAR_DISCOVERY);
        registry.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarConstellation>(ContainerAltarConstellation.class, stackHelper, transferHelper, 21), CATEGORY_ALTAR_DISCOVERY);
        registry.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarTrait>(ContainerAltarTrait.class, stackHelper, transferHelper, 25), CATEGORY_ALTAR_DISCOVERY);
        registry.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarAttunement>(ContainerAltarAttunement.class, stackHelper, transferHelper, 13), CATEGORY_ALTAR_ATTUNEMENT);
        registry.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarConstellation>(ContainerAltarConstellation.class, stackHelper, transferHelper, 21), CATEGORY_ALTAR_ATTUNEMENT);
        registry.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarTrait>(ContainerAltarTrait.class, stackHelper, transferHelper, 25), CATEGORY_ALTAR_ATTUNEMENT);
        registry.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarConstellation>(ContainerAltarConstellation.class, stackHelper, transferHelper, 21), CATEGORY_ALTAR_CONSTELLATION);
        registry.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarTrait>(ContainerAltarTrait.class, stackHelper, transferHelper, 25), CATEGORY_ALTAR_CONSTELLATION);
        registry.addRecipeTransferHandler(new TieredAltarRecipeTransferHandler<ContainerAltarTrait>(ContainerAltarTrait.class, stackHelper, transferHelper, 25), CATEGORY_ALTAR_TRAIT);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }

    public ResourceLocation getPluginUid() {
        return AstralSorcery.key("jei_integration");
    }
}

