/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry.sets;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;

public class OreItemRarityEntry
implements ConfigDataSet {
    private final ITag<Item> itemTag;
    private final ResourceLocation key;
    private final int weight;

    public OreItemRarityEntry(ITag<Item> itemTag, ResourceLocation key, int weight) {
        this.itemTag = itemTag;
        this.key = key;
        this.weight = weight;
    }

    public OreItemRarityEntry(ITag.INamedTag<Item> itemTag, int weight) {
        this((ITag<Item>)itemTag, itemTag.func_230234_a_(), weight);
    }

    public int getWeight() {
        return this.weight;
    }

    @Nullable
    public Item getRandomItem(Random rand) {
        return (Item)MiscUtils.getRandomEntry(this.itemTag.func_230236_b_().stream().filter(item -> !((List)GeneralConfig.CONFIG.modidOreBlacklist.get()).contains(item.getRegistryName().func_110624_b())).collect(Collectors.toList()), rand);
    }

    @Nullable
    public static OreItemRarityEntry deserialize(String str) throws IllegalArgumentException {
        int weight;
        String[] split = str.split(";");
        if (split.length != 2) {
            return null;
        }
        ResourceLocation keyItemTag = new ResourceLocation(split[0]);
        ITag itemTag = ItemTags.func_199903_a().func_199910_a(keyItemTag);
        if (itemTag == null) {
            return null;
        }
        String strWeight = split[1];
        try {
            weight = Integer.parseInt(strWeight);
        }
        catch (NumberFormatException exc) {
            return null;
        }
        return new OreItemRarityEntry((ITag<Item>)itemTag, keyItemTag, weight);
    }

    @Override
    @Nonnull
    public String serialize() {
        return String.format("%s;%s", this.key.toString(), this.weight);
    }
}

