/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config.registry.sets;

import hellfirepvp.astralsorcery.common.data.config.base.ConfigDataSet;
import hellfirepvp.astralsorcery.common.data.config.entry.GeneralConfig;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class OreBlockRarityEntry
implements ConfigDataSet {
    private final ITag<Block> blockTag;
    private final ResourceLocation key;
    private final int weight;

    public OreBlockRarityEntry(ITag<Block> blockTag, ResourceLocation key, int weight) {
        this.blockTag = blockTag;
        this.key = key;
        this.weight = weight;
    }

    public OreBlockRarityEntry(ITag.INamedTag<Block> blockTag, int weight) {
        this((ITag<Block>)blockTag, blockTag.func_230234_a_(), weight);
    }

    public int getWeight() {
        return this.weight;
    }

    @Nullable
    public Block getRandomBlock(Random rand) {
        return (Block)MiscUtils.getRandomEntry(this.blockTag.func_230236_b_().stream().filter(item -> !((List)GeneralConfig.CONFIG.modidOreBlacklist.get()).contains(item.getRegistryName().func_110624_b())).collect(Collectors.toList()), rand);
    }

    @Nullable
    public static OreBlockRarityEntry deserialize(String str) throws IllegalArgumentException {
        int weight;
        String[] split = str.split(";");
        if (split.length != 2) {
            return null;
        }
        ResourceLocation keyBlockTag = new ResourceLocation(split[0]);
        ITag blockTag = BlockTags.func_199896_a().func_199910_a(keyBlockTag);
        if (blockTag == null) {
            return null;
        }
        String strWeight = split[1];
        try {
            weight = Integer.parseInt(strWeight);
        }
        catch (NumberFormatException exc) {
            return null;
        }
        return new OreBlockRarityEntry((ITag<Block>)blockTag, keyBlockTag, weight);
    }

    @Override
    @Nonnull
    public String serialize() {
        return String.format("%s;%s", this.key.toString(), this.weight);
    }
}

