/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import hellfirepvp.astralsorcery.common.crafting.recipe.WellLiquefaction;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.JsonHelper;
import java.awt.Color;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class WellRecipeSerializer
extends CustomRecipeSerializer<WellLiquefaction> {
    public WellRecipeSerializer() {
        super(RecipeSerializersAS.WELL_LIQUEFACTION);
    }

    public WellLiquefaction read(ResourceLocation recipeId, JsonObject json) {
        Ingredient input = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
        String fluidKey = JSONUtils.func_151200_h((JsonObject)json, (String)"output");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidKey));
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid: " + fluidKey);
        }
        float productionMultiplier = JSONUtils.func_151217_k((JsonObject)json, (String)"productionMultiplier");
        float shatterMultiplier = JSONUtils.func_151217_k((JsonObject)json, (String)"shatterMultiplier");
        Color color = null;
        if (json.has("color")) {
            color = JsonHelper.getColor(json, "color");
        }
        return new WellLiquefaction(recipeId, input, fluid, color, productionMultiplier, shatterMultiplier);
    }

    public WellLiquefaction read(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
        Fluid fluid = (Fluid)ByteBufUtils.readRegistryEntry(buffer);
        float shatter = buffer.readFloat();
        float production = buffer.readFloat();
        Color color = ByteBufUtils.readOptional(buffer, buf -> new Color(buf.readInt(), true));
        return new WellLiquefaction(recipeId, input, fluid, color, production, shatter);
    }

    public void write(PacketBuffer buffer, WellLiquefaction recipe) {
        recipe.getInput().func_199564_a(buffer);
        ByteBufUtils.writeRegistryEntry(buffer, recipe.getFluidOutput());
        buffer.writeFloat(recipe.getShatterMultiplier());
        buffer.writeFloat(recipe.getProductionMultiplier());
        ByteBufUtils.writeOptional(buffer, recipe.getCatalystColor(), (buf, color) -> buf.writeInt(color.getRGB()));
    }

    @Override
    public void write(JsonObject object, WellLiquefaction recipe) {
        object.add("input", recipe.getInput().func_200304_c());
        object.addProperty("output", recipe.getFluidOutput().getRegistryName().toString());
        object.addProperty("productionMultiplier", (Number)Float.valueOf(recipe.getProductionMultiplier()));
        object.addProperty("shatterMultiplier", (Number)Float.valueOf(recipe.getShatterMultiplier()));
        object.addProperty("color", (Number)(recipe.getCatalystColor() == null ? Color.WHITE.getRGB() : recipe.getCatalystColor().getRGB()));
    }
}

