/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.util.block.BlockDiscoverer;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.items.CapabilityItemHandler;

public class MantleEffectLucerna
extends MantleEffect {
    public static LucernaConfig CONFIG = new LucernaConfig();

    public MantleEffectLucerna() {
        super(ConstellationsAS.lucerna);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        this.playCapeSparkles(player, 0.15f);
        if (rand.nextBoolean()) {
            this.playEntityHighlight(player);
        }
        if (((Boolean)MantleEffectLucerna.CONFIG.findSpawners.get()).booleanValue() && rand.nextInt(10) == 0) {
            this.playBlockHighlight(player, ColorsAS.MANTLE_LUCERNA_SPAWNER, tileEntity -> tileEntity instanceof MobSpawnerTileEntity);
        }
        if (((Boolean)MantleEffectLucerna.CONFIG.findChests.get()).booleanValue() && rand.nextInt(10) == 0) {
            this.playBlockHighlight(player, ColorsAS.MANTLE_LUCERNA_INVENTORY, tileEntity -> tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playBlockHighlight(PlayerEntity player, Color highlightColor, Predicate<TileEntity> test) {
        float chance = 0.9f;
        Set<BlockPos> positions = BlockDiscoverer.searchForTileEntitiesAround(player.func_130014_f_(), player.func_233580_cy_(), (Integer)MantleEffectLucerna.CONFIG.range.get(), test);
        for (BlockPos pos : positions) {
            Vector3 at;
            if (rand.nextFloat() > chance || (at = new Vector3((Vector3i)pos).add(rand.nextFloat(), rand.nextFloat(), rand.nextFloat())).distance((Entity)player) < 4.0) continue;
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.GENERIC_DEPTH_PARTICLE).setOwner(player.func_110124_au())).spawn(at)).color(VFXColorFunction.constant(highlightColor))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.4f + rand.nextFloat() * 0.4f)).setMaxAge(30 + rand.nextInt(15));
            if (rand.nextFloat() > 0.35f) {
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.GENERIC_DEPTH_PARTICLE).setOwner(player.func_110124_au())).spawn(at)).color(VFXColorFunction.WHITE)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.2f)).setMaxAge(20 + rand.nextInt(10));
            }
            chance *= 0.9f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEntityHighlight(PlayerEntity player) {
        AxisAlignedBB box = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g((double)((Integer)MantleEffectLucerna.CONFIG.range.get()).intValue()).func_186670_a(player.func_233580_cy_());
        List entities = player.func_130014_f_().func_217357_a(LivingEntity.class, box);
        for (LivingEntity entity : entities) {
            Vector3 atEntity;
            if (!entity.func_70089_S() || entity.equals((Object)player) || rand.nextInt(8) != 0 || (atEntity = Vector3.atEntityCorner((Entity)entity)).distance((Entity)player) < 2.0) continue;
            atEntity.add(rand.nextFloat() * entity.func_213311_cf(), rand.nextFloat() * entity.func_213302_cg(), rand.nextFloat() * entity.func_213311_cf());
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.GENERIC_DEPTH_PARTICLE).setOwner(player.func_110124_au())).spawn(atEntity)).color(VFXColorFunction.constant(this.getAssociatedConstellation().getConstellationColor()))).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.4f + rand.nextFloat() * 0.4f)).setMaxAge(30 + rand.nextInt(15));
            if (!(rand.nextFloat() > 0.35f)) continue;
            ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)((EffectHelper.Builder)EffectHelper.of(EffectTemplatesAS.GENERIC_DEPTH_PARTICLE).setOwner(player.func_110124_au())).spawn(atEntity)).color(VFXColorFunction.WHITE)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.2f)).setMaxAge(20 + rand.nextInt(10));
        }
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    public static class LucernaConfig
    extends MantleEffect.Config {
        private final int defaultRange = 48;
        private final boolean defaultFindSpawners = true;
        private final boolean defaultFindChests = true;
        public ForgeConfigSpec.IntValue range;
        public ForgeConfigSpec.BooleanValue findSpawners;
        public ForgeConfigSpec.BooleanValue findChests;

        public LucernaConfig() {
            super("lucerna");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            this.range = cfgBuilder.comment("Sets the maximum range of where the lucerna cape effect will get entities (and potentially other stuff given the config option for that is enabled) to highlight.").translation(this.translationKey("range")).defineInRange("range", this.defaultRange, 0, 512);
            ForgeConfigSpec.Builder builder = cfgBuilder.comment("If this is set to true, particles spawned by the lucerna cape effect will also highlight spawners nearby.").translation(this.translationKey("findSpawners"));
            this.getClass();
            this.findSpawners = builder.define("findSpawners", true);
            ForgeConfigSpec.Builder builder2 = cfgBuilder.comment("If this is set to true, particles spawned by the lucerna cape effect will also highlight chests nearby.").translation(this.translationKey("findChests"));
            this.getClass();
            this.findChests = builder2.define("findChests", true);
        }
    }
}

