/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.tile;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.GuiType;
import hellfirepvp.astralsorcery.common.event.EventFlags;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class BlockStructural
extends Block {
    public static EnumProperty<BlockType> BLOCK_TYPE = EnumProperty.func_177709_a((String)"blocktype", BlockType.class);
    private static final VoxelShape STRUCT_TELESCOPE = VoxelShapes.func_197873_a((double)0.0625, (double)-1.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);

    public BlockStructural() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_175972_I, (MaterialColor)MaterialColor.field_151660_b).func_200947_a(SoundType.field_185853_f));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(BLOCK_TYPE, (Comparable)((Object)BlockType.TELESCOPE)));
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BLOCK_TYPE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE: {
                return STRUCT_TELESCOPE;
            }
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))).getSupportedState().getHarvestTool();
    }

    public int getHarvestLevel(BlockState state) {
        return ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))).getSupportedState().getHarvestLevel();
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE: {
                return SoundType.field_185848_a;
            }
        }
        return super.getSoundType(state, world, pos, entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        EventFlags.PLAY_BLOCK_BREAK_EFFECTS.executeWithFlag(() -> {
            switch ((BlockType)((Object)((Object)state.func_177229_b(BLOCK_TYPE)))) {
                case TELESCOPE: {
                    manager.func_180533_a(pos.func_177977_b(), BlocksAS.TELESCOPE.func_176223_P());
                }
            }
        });
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target instanceof BlockRayTraceResult) {
            EventFlags.PLAY_BLOCK_BREAK_EFFECTS.executeWithFlag(() -> {
                switch ((BlockType)((Object)((Object)state.func_177229_b(BLOCK_TYPE)))) {
                    case TELESCOPE: {
                        manager.func_180533_a(((BlockRayTraceResult)target).func_216350_a().func_177977_b(), BlocksAS.TELESCOPE.func_176223_P());
                    }
                }
            });
        }
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity entity, Hand hand, BlockRayTraceResult rayTraceResult) {
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE: {
                if (world.func_201670_d()) {
                    AstralSorcery.getProxy().openGui(entity, GuiType.TELESCOPE, pos.func_177977_b());
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, world, pos, entity, hand, rayTraceResult);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList drops = Lists.newArrayList();
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE: {
                return BlockType.TELESCOPE.getSupportedState().func_215693_a(builder);
            }
        }
        return drops;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE: {
                return BlockType.TELESCOPE.getSupportedState().getPickBlock(target, world, pos.func_177977_b(), player);
            }
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE: {
                if (world.func_175623_d(pos.func_177977_b())) {
                    world.func_217377_a(pos, isMoving);
                }
                return;
            }
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        if (!(world instanceof IWorldWriter)) {
            return;
        }
        switch ((BlockType)((Object)state.func_177229_b(BLOCK_TYPE))) {
            case TELESCOPE: {
                if (!world.func_175623_d(pos.func_177977_b())) break;
                ((IWorldWriter)world).func_217377_a(pos, false);
            }
        }
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.INVISIBLE;
    }

    public static enum BlockType implements IStringSerializable
    {
        DUMMY(Blocks.field_150350_a.func_176223_P()),
        TELESCOPE(BlocksAS.TELESCOPE.func_176223_P());

        private final BlockState supportedState;

        private BlockType(BlockState supportedState) {
            this.supportedState = supportedState;
        }

        public BlockState getSupportedState() {
            return this.supportedState;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

