/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum Mods {
    MINECRAFT("minecraft", true),
    FORGE("forge", true),
    ASTRAL_SORCERY("astralsorcery", true),
    DRACONIC_EVOLUTION("draconicevolution"),
    CURIOS("curios"),
    JEI("jei"),
    BOTANIA("botania"),
    CRAFTTWEAKER("crafttweaker");

    private final String modid;
    private final boolean loaded;

    private Mods(String modid) {
        this(modid, ModList.get().isLoaded(modid));
    }

    private Mods(String modid, boolean loaded) {
        this.modid = modid;
        this.loaded = loaded;
    }

    public String getModId() {
        return this.modid;
    }

    public boolean isPresent() {
        return this.loaded;
    }

    public void executeIfPresent(Supplier<Runnable> execSupplier) {
        if (this.isPresent()) {
            execSupplier.get().run();
        }
    }

    @Nullable
    public <T> T getIfPresent(Supplier<Supplier<T>> supplierSupplier) {
        if (this.isPresent()) {
            return supplierSupplier.get().get();
        }
        return null;
    }

    public boolean owns(IForgeRegistryEntry<?> entry) {
        return this.isPresent() && entry.getRegistryName() != null && entry.getRegistryName().func_110624_b().equals(this.modid);
    }

    @Nonnull
    public ResourceLocation key(String path) {
        return new ResourceLocation(this.getModId(), path);
    }

    public void sendIMC(String method, Supplier<?> thing) {
        if (this.isPresent()) {
            InterModComms.sendTo((String)"astralsorcery", (String)this.getModId(), (String)method, thing);
        }
    }

    @Nullable
    public static Mods byModId(String modId) {
        for (Mods mod : Mods.values()) {
            if (!mod.getModId().equals(modId)) continue;
            return mod;
        }
        return null;
    }

    @Nullable
    public Class<?> getExtendedPlayerClass() {
        if (!this.isPresent()) {
            return null;
        }
        return null;
    }
}

