/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.image;

import hellfirepvp.astralsorcery.client.util.image.ImageTemplate;
import hellfirepvp.astralsorcery.client.util.image.ImageTemplates;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.apache.logging.log4j.util.TriConsumer;

public class SkyImageGenerator {
    public static BufferedImage generateStarBackground() {
        BufferedImage image = SkyImageGenerator.createBackground();
        SkyImageGenerator.placeRandomly(ImageTemplates.getLargeStar(), image, 200);
        SkyImageGenerator.placeRandomly(ImageTemplates.getSmallStar(), image, 500);
        SkyImageGenerator.placeRandomly(ImageTemplates.getDot(-2130706433), image, 300);
        SkyImageGenerator.placeRandomly(ImageTemplates.getDot(0x40FFFFFF), image, 600);
        return image;
    }

    private static void placeRandomly(ImageTemplate template, BufferedImage out, int count) {
        Random rand = new Random();
        for (int i = 0; i < count; ++i) {
            int offsetX = rand.nextInt(out.getWidth() - template.getWidth());
            int offsetY = rand.nextInt(out.getHeight() - template.getHeight());
            template.place(SkyImageGenerator.createColorPlacer(offsetX, offsetY, rand, out));
        }
    }

    private static TriConsumer<Integer, Integer, Integer> createColorPlacer(int offsetX, int offsetY, Random rand, BufferedImage out) {
        return (oX, oY, color) -> {
            int x = oX + offsetX;
            int y = oY + offsetY;
            int newColor = SkyImageGenerator.blendAlphaAdditively(out.getRGB(x, y), color, 0.8f + rand.nextFloat() * 0.2f);
            out.setRGB(x, y, SkyImageGenerator.convertToABGR(newColor));
        };
    }

    private static int convertToABGR(int color) {
        return color & 0xFF00FF00 | color >> 16 & 0xFF | (color & 0xFF) << 16;
    }

    private static int blendAlphaAdditively(int existing, int toWrite, float alphaMulOut) {
        int existingAlpha = existing >> 24 & 0xFF;
        int newAlpha = Math.round((float)(toWrite >> 24) * alphaMulOut) & 0xFF;
        float partNew = (float)newAlpha / 255.0f;
        float partOld = 1.0f - partNew;
        int newColorAdd = Math.min(Math.round((float)(existing >> 16 & 0xFF) * partOld + (float)(toWrite >> 16 & 0xFF) * partNew), 255) << 16 | Math.min(Math.round((float)(existing >> 8 & 0xFF) * partOld + (float)(toWrite >> 8 & 0xFF) * partNew), 255) << 8 | Math.min(Math.round((float)(existing & 0xFF) * partOld + (float)(toWrite & 0xFF) * partNew), 255);
        return newColorAdd & 0xFFFFFF | (Math.min(existingAlpha + newAlpha, 255) & 0xFF) << 24;
    }

    private static BufferedImage createBackground() {
        BufferedImage image = new BufferedImage(512, 512, 6);
        Graphics2D draw = image.createGraphics();
        draw.setColor(Color.BLACK);
        draw.fillRect(0, 0, image.getWidth(), image.getHeight());
        return image;
    }
}

