/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.lib.RenderTypesAS;
import hellfirepvp.astralsorcery.client.render.tile.CustomTileEntityRenderer;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.tile.TileWell;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.tile.PrecisionSingleFluidTank;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.fluids.FluidStack;

public class RenderWell
extends CustomTileEntityRenderer<TileWell> {
    public RenderWell(TileEntityRendererDispatcher tileRenderer) {
        super(tileRenderer);
    }

    public void render(TileWell tile, float pTicks, MatrixStack renderStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        ItemStack catalyst;
        PrecisionSingleFluidTank tank = tile.getTank();
        if (!tank.getFluid().isEmpty() && tank.getFluidAmount() > 0) {
            FluidStack contained = tank.getFluid();
            TextureAtlasSprite tas = RenderingUtils.getParticleTexture(contained);
            Color fluidColor = new Color(contained.getFluid().getAttributes().getColor((IBlockDisplayReader)tile.func_145831_w(), tile.func_174877_v()));
            IVertexBuilder buf = renderTypeBuffer.getBuffer(RenderTypesAS.TER_WELL_LIQUID);
            Vector3 offset = new Vector3(0.5, 0.32, 0.5).addY((double)tank.getPercentageFilled() * 0.6);
            RenderingDrawUtils.renderAngleRotatedTexturedRectVB(buf, renderStack, offset, Vector3.RotAxis.Y_AXIS, (float)Math.toRadians(45.0), 0.54f, tas.func_94209_e(), tas.func_94206_g(), tas.func_94212_f() - tas.func_94209_e(), tas.func_94210_h() - tas.func_94206_g(), fluidColor.getRed(), fluidColor.getGreen(), fluidColor.getBlue(), 255);
        }
        if (!(catalyst = tile.getInventory().getStackInSlot(0)).func_190926_b()) {
            RenderingUtils.renderItemAsEntity(catalyst, renderStack, renderTypeBuffer, 0.5, 0.75, 0.5, combinedLight, pTicks, tile.getTicksExisted());
        }
    }
}

