/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.registry;

import hellfirepvp.astralsorcery.client.input.KeyBindingWrapper;
import hellfirepvp.astralsorcery.client.input.KeyDisablePerkAbilities;
import hellfirepvp.astralsorcery.client.lib.KeyBindingsAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class RegistryKeyBindings {
    private static final Set<KeyBindingWrapper> watchedKeyBindings = new HashSet<KeyBindingWrapper>();
    private static final Set<KeyBindingWrapper> bindingsPressed = new HashSet<KeyBindingWrapper>();

    public static void init() {
        KeyBindingsAS.DISABLE_PERK_ABILITIES = RegistryKeyBindings.register("disable_perk_abilities", 86, KeyDisablePerkAbilities::new);
        MinecraftForge.EVENT_BUS.addListener(RegistryKeyBindings::onKeyInput);
    }

    private static KeyBindingWrapper register(String name, int glfwKey) {
        return RegistryKeyBindings.register(name, glfwKey, keyBinding -> new KeyBindingWrapper((KeyBinding)keyBinding){});
    }

    private static KeyBindingWrapper register(String name, int glfwKey, Function<KeyBinding, KeyBindingWrapper> wrapperCreator) {
        KeyBinding keyBinding = new KeyBinding(String.format("key.%s.%s", "astralsorcery", name), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, glfwKey, "Astral Sorcery");
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        KeyBindingWrapper wrapper = wrapperCreator.apply(keyBinding);
        watchedKeyBindings.add(wrapper);
        return wrapper;
    }

    private static void onKeyInput(InputEvent.KeyInputEvent event) {
        boolean wasPressed;
        boolean isPressed;
        InputMappings.Input input = InputMappings.func_197954_a((int)event.getKey(), (int)event.getScanCode());
        KeyBindingWrapper eventKey = MiscUtils.iterativeSearch(watchedKeyBindings, keyBinding -> keyBinding.getKeyBinding().getKey().equals((Object)input));
        if (eventKey != null && (isPressed = eventKey.getKeyBinding().func_151470_d()) != (wasPressed = bindingsPressed.contains(eventKey))) {
            if (isPressed) {
                bindingsPressed.add(eventKey);
                eventKey.onKeyDown();
            } else {
                bindingsPressed.remove(eventKey);
                eventKey.onKeyUp();
            }
        }
    }
}

