/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.event.TurtleAction;
import dan200.computercraft.api.turtle.event.TurtleActionEvent;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TurtleEquipCommand
implements ITurtleCommand {
    private final TurtleSide side;

    public TurtleEquipCommand(TurtleSide side) {
        this.side = side;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        ItemStack remainder;
        ItemStack craftingItem;
        ITurtleUpgrade oldUpgrade;
        ITurtleUpgrade newUpgrade;
        ItemStack newUpgradeStack;
        IItemHandlerModifiable inventory = turtle.getItemHandler();
        ItemStack selectedStack = inventory.getStackInSlot(turtle.getSelectedSlot());
        if (!selectedStack.func_190926_b()) {
            newUpgradeStack = selectedStack.func_77946_l();
            newUpgrade = TurtleUpgrades.get(newUpgradeStack);
            if (newUpgrade == null || !TurtleUpgrades.suitableForFamily(((TurtleBrain)turtle).getFamily(), newUpgrade)) {
                return TurtleCommandResult.failure("Not a valid upgrade");
            }
        } else {
            newUpgradeStack = null;
            newUpgrade = null;
        }
        ItemStack oldUpgradeStack = (oldUpgrade = turtle.getUpgrade(this.side)) != null ? (!(craftingItem = oldUpgrade.getCraftingItem()).func_190926_b() ? craftingItem.func_77946_l() : null) : null;
        TurtleActionEvent event = new TurtleActionEvent(turtle, TurtleAction.EQUIP);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return TurtleCommandResult.failure(event.getFailureMessage());
        }
        if (newUpgradeStack != null) {
            InventoryUtil.takeItems(1, (IItemHandler)inventory, turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
        }
        if (oldUpgradeStack != null && !(remainder = InventoryUtil.storeItems(oldUpgradeStack, (IItemHandler)inventory, turtle.getSelectedSlot())).func_190926_b()) {
            BlockPos position = turtle.getPosition();
            WorldUtil.dropItemStack(remainder, turtle.getWorld(), position, turtle.getDirection());
        }
        turtle.setUpgrade(this.side, newUpgrade);
        if (newUpgrade != null || oldUpgrade != null) {
            turtle.playAnimation(TurtleAnimation.WAIT);
        }
        return TurtleCommandResult.success();
    }
}

