/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class ServerMonitor {
    private final TileMonitor origin;
    private final boolean colour;
    private int textScale = 2;
    @Nullable
    private Terminal terminal;
    private final AtomicBoolean resized = new AtomicBoolean(false);
    private final AtomicBoolean changed = new AtomicBoolean(false);

    ServerMonitor(boolean colour, TileMonitor origin) {
        this.colour = colour;
        this.origin = origin;
    }

    synchronized void rebuild() {
        Terminal oldTerm = this.getTerminal();
        int oldWidth = oldTerm == null ? -1 : oldTerm.getWidth();
        int oldHeight = oldTerm == null ? -1 : oldTerm.getHeight();
        double textScale = (double)this.textScale * 0.5;
        int termWidth = (int)Math.max((double)Math.round(((double)this.origin.getWidth() - 0.3125) / (textScale * 6.0 * 0.015625)), 1.0);
        int termHeight = (int)Math.max((double)Math.round(((double)this.origin.getHeight() - 0.3125) / (textScale * 9.0 * 0.015625)), 1.0);
        if (this.terminal == null) {
            this.terminal = new Terminal(termWidth, termHeight, this.colour, this::markChanged);
            this.markChanged();
        } else {
            this.terminal.resize(termWidth, termHeight);
        }
        if (oldWidth != termWidth || oldHeight != termHeight) {
            this.terminal.clear();
            this.resized.set(true);
            this.markChanged();
        }
    }

    private void markChanged() {
        if (!this.changed.getAndSet(true)) {
            TickScheduler.schedule(this.origin.tickToken);
        }
    }

    int getTextScale() {
        return this.textScale;
    }

    synchronized void setTextScale(int textScale) {
        if (this.textScale == textScale) {
            return;
        }
        this.textScale = textScale;
        this.rebuild();
    }

    boolean pollResized() {
        return this.resized.getAndSet(false);
    }

    boolean pollTerminalChanged() {
        return this.changed.getAndSet(false);
    }

    @Nullable
    @VisibleForTesting
    public Terminal getTerminal() {
        return this.terminal;
    }
}

