/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.integration.Optifine;
import javax.annotation.Nonnull;
import org.lwjgl.opengl.GL;

public enum MonitorRenderer {
    BEST,
    TBO,
    VBO;


    @Nonnull
    public static MonitorRenderer current() {
        MonitorRenderer current = ComputerCraft.monitorRenderer;
        if (current == BEST) {
            current = ComputerCraft.monitorRenderer = MonitorRenderer.best();
        }
        return current;
    }

    private static MonitorRenderer best() {
        if (!GL.getCapabilities().OpenGL31) {
            ComputerCraft.log.warn("Texture buffers are not supported on your graphics card. Falling back to VBO monitor renderer.");
            return VBO;
        }
        if (Optifine.isLoaded()) {
            ComputerCraft.log.warn("Optifine is loaded, assuming shaders are being used. Falling back to VBO monitor renderer.");
            return VBO;
        }
        return TBO;
    }
}

