/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.BlockWirelessModem;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.TickScheduler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileWirelessModem
extends TileGeneric {
    private final boolean advanced;
    private boolean hasModemDirection = false;
    private Direction modemDirection = Direction.DOWN;
    private final ModemPeripheral modem;
    private boolean destroyed = false;
    private LazyOptional<IPeripheral> modemCap;
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);

    public TileWirelessModem(TileEntityType<? extends TileWirelessModem> type, boolean advanced) {
        super(type);
        this.advanced = advanced;
        this.modem = new Peripheral(this);
    }

    public void onLoad() {
        super.onLoad();
        TickScheduler.schedule(this.tickToken);
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.modem.destroy();
            this.destroyed = true;
        }
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.hasModemDirection = false;
        this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 0);
    }

    @Override
    public void blockTick() {
        Direction currentDirection = this.modemDirection;
        this.refreshDirection();
        if (currentDirection != this.modemDirection) {
            this.modemCap = CapabilityUtil.invalidate(this.modemCap);
        }
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
    }

    private void refreshDirection() {
        if (this.hasModemDirection) {
            return;
        }
        this.hasModemDirection = true;
        this.modemDirection = (Direction)this.func_195044_w().func_177229_b((Property)BlockWirelessModem.FACING);
    }

    private void updateBlockState() {
        boolean on = this.modem.getModemState().isOpen();
        BlockState state = this.func_195044_w();
        if ((Boolean)state.func_177229_b((Property)BlockWirelessModem.ON) != on) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a((Property)BlockWirelessModem.ON, (Comparable)Boolean.valueOf(on)));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            this.refreshDirection();
            if (side != null && this.modemDirection != side) {
                return LazyOptional.empty();
            }
            if (this.modemCap == null) {
                this.modemCap = LazyOptional.of(() -> this.modem);
            }
            return this.modemCap.cast();
        }
        return super.getCapability(cap, side);
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final TileWirelessModem entity;

        Peripheral(TileWirelessModem entity) {
            super(new ModemState(() -> TickScheduler.schedule(entity.tickToken)), entity.advanced);
            this.entity = entity;
        }

        @Override
        @Nonnull
        public World getWorld() {
            return this.entity.func_145831_w();
        }

        @Override
        @Nonnull
        public Vector3d getPosition() {
            return Vector3d.func_237491_b_((Vector3i)this.entity.func_174877_v().func_177972_a(this.entity.modemDirection));
        }

        @Override
        public boolean equals(IPeripheral other) {
            return this == other || other instanceof Peripheral && this.entity == ((Peripheral)other).entity;
        }

        @Override
        @Nonnull
        public Object getTarget() {
            return this.entity;
        }
    }
}

