/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.pocket.ClientPocketComputers;
import dan200.computercraft.client.pocket.PocketComputerData;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.TerminalState;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PocketComputerDataMessage
implements NetworkMessage {
    private final int instanceId;
    private final ComputerState state;
    private final int lightState;
    private final TerminalState terminal;

    public PocketComputerDataMessage(PocketServerComputer computer, boolean sendTerminal) {
        this.instanceId = computer.getInstanceID();
        this.state = computer.getState();
        this.lightState = computer.getLight();
        this.terminal = sendTerminal ? computer.getTerminalState() : new TerminalState((Terminal)null);
    }

    public PocketComputerDataMessage(PacketBuffer buf) {
        this.instanceId = buf.func_150792_a();
        this.state = (ComputerState)buf.func_179257_a(ComputerState.class);
        this.lightState = buf.func_150792_a();
        this.terminal = new TerminalState(buf);
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_150787_b(this.instanceId);
        buf.func_179249_a((Enum)this.state);
        buf.func_150787_b(this.lightState);
        this.terminal.write(buf);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        PocketComputerData computer = ClientPocketComputers.get(this.instanceId, this.terminal.colour);
        computer.setState(this.state, this.lightState);
        if (this.terminal.hasTerminal()) {
            computer.setTerminal(this.terminal);
        }
    }
}

