/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.core.filesystem.SubMount;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.util.Colour;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ItemTreasureDisk
extends Item
implements IMedia {
    private static final String NBT_TITLE = "Title";
    private static final String NBT_COLOUR = "Colour";
    private static final String NBT_SUB_PATH = "SubPath";

    public ItemTreasureDisk(Item.Properties settings) {
        super(settings);
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> stacks) {
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> list, @Nonnull ITooltipFlag tooltipOptions) {
        String label = ItemTreasureDisk.getTitle(stack);
        if (!label.isEmpty()) {
            list.add((ITextComponent)new StringTextComponent(label));
        }
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return ItemTreasureDisk.getTitle(stack);
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull World world) {
        IMount rootTreasure = ItemTreasureDisk.getTreasureMount();
        if (rootTreasure == null) {
            return null;
        }
        String subPath = ItemTreasureDisk.getSubPath(stack);
        try {
            if (rootTreasure.exists(subPath)) {
                return new SubMount(rootTreasure, subPath);
            }
            if (rootTreasure.exists("deprecated/" + subPath)) {
                return new SubMount(rootTreasure, "deprecated/" + subPath);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static ItemStack create(String subPath, int colourIndex) {
        ItemStack result = new ItemStack((IItemProvider)Registry.ModItems.TREASURE_DISK.get());
        CompoundNBT nbt = result.func_196082_o();
        nbt.func_74778_a(NBT_SUB_PATH, subPath);
        int slash = subPath.indexOf(47);
        if (slash >= 0) {
            String author = subPath.substring(0, slash);
            String title = subPath.substring(slash + 1);
            nbt.func_74778_a(NBT_TITLE, "\"" + title + "\" by " + author);
        } else {
            nbt.func_74778_a(NBT_TITLE, "untitled");
        }
        nbt.func_74768_a(NBT_COLOUR, Colour.values()[colourIndex].getHex());
        return result;
    }

    private static IMount getTreasureMount() {
        return ComputerCraftAPI.createResourceMount("computercraft", "lua/treasure");
    }

    @Nonnull
    private static String getTitle(@Nonnull ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(NBT_TITLE) ? nbt.func_74779_i(NBT_TITLE) : "'missingno' by how did you get this anyway?";
    }

    @Nonnull
    private static String getSubPath(@Nonnull ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(NBT_SUB_PATH) ? nbt.func_74779_i(NBT_SUB_PATH) : "dan200/alongtimeago";
    }

    public static int getColour(@Nonnull ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(NBT_COLOUR) ? nbt.func_74762_e(NBT_COLOUR) : Colour.BLUE.getHex();
    }
}

