/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.InputHandler;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.TerminalState;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ServerComputer
implements InputHandler,
ComputerEnvironment {
    private final int instanceID;
    private ServerWorld world;
    private BlockPos position;
    private final ComputerFamily family;
    private final MetricsObserver metrics;
    private final Computer computer;
    private final Terminal terminal;
    private final AtomicBoolean terminalChanged = new AtomicBoolean(false);
    private boolean changedLastFrame;
    private int ticksSincePing;

    public ServerComputer(ServerWorld world, int computerID, String label, ComputerFamily family, int terminalWidth, int terminalHeight) {
        this.world = world;
        this.family = family;
        ServerContext context = ServerContext.get(world.func_73046_m());
        this.instanceID = context.registry().getUnusedInstanceID();
        this.terminal = new Terminal(terminalWidth, terminalHeight, family != ComputerFamily.NORMAL, this::markTerminalChanged);
        this.metrics = context.metrics().createMetricObserver(this);
        this.computer = new Computer(context.computerContext(), this, this.terminal, computerID);
        this.computer.setLabel(label);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public ServerWorld getWorld() {
        return this.world;
    }

    public void setWorld(ServerWorld world) {
        this.world = world;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void setPosition(BlockPos pos) {
        this.position = new BlockPos((Vector3i)pos);
    }

    public IAPIEnvironment getAPIEnvironment() {
        return this.computer.getAPIEnvironment();
    }

    public Computer getComputer() {
        return this.computer;
    }

    protected void markTerminalChanged() {
        this.terminalChanged.set(true);
    }

    public void tickServer() {
        ++this.ticksSincePing;
        this.computer.tick();
        this.changedLastFrame = this.computer.pollAndResetChanged();
        if (this.terminalChanged.getAndSet(false)) {
            this.onTerminalChanged();
        }
    }

    protected void onTerminalChanged() {
        this.sendToAllInteracting(c -> new ComputerTerminalClientMessage((Container)c, this.getTerminalState()));
    }

    public TerminalState getTerminalState() {
        return new TerminalState(this.terminal);
    }

    public void keepAlive() {
        this.ticksSincePing = 0;
    }

    public boolean hasTimedOut() {
        return this.ticksSincePing > 100;
    }

    public boolean hasOutputChanged() {
        return this.changedLastFrame;
    }

    public int register() {
        ServerContext.get(this.world.func_73046_m()).registry().add(this.instanceID, this);
        return this.instanceID;
    }

    void unload() {
        this.computer.unload();
    }

    public void close() {
        this.unload();
        ServerContext.get(this.world.func_73046_m()).registry().remove(this.instanceID);
    }

    private void sendToAllInteracting(Function<Container, NetworkMessage> createPacket) {
        MinecraftServer server = this.world.func_73046_m();
        for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
            if (!(player.field_71070_bA instanceof ComputerMenu) || ((ComputerMenu)player.field_71070_bA).getComputer() != this) continue;
            NetworkHandler.sendToPlayer(player, createPacket.apply(player.field_71070_bA));
        }
    }

    protected void onRemoved() {
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    public int getID() {
        return this.computer.getID();
    }

    public String getLabel() {
        return this.computer.getLabel();
    }

    public boolean isOn() {
        return this.computer.isOn();
    }

    public ComputerState getState() {
        if (!this.isOn()) {
            return ComputerState.OFF;
        }
        return this.computer.isBlinking() ? ComputerState.BLINKING : ComputerState.ON;
    }

    @Override
    public void turnOn() {
        this.computer.turnOn();
    }

    @Override
    public void shutdown() {
        this.computer.shutdown();
    }

    @Override
    public void reboot() {
        this.computer.reboot();
    }

    @Override
    public void queueEvent(String event, Object[] arguments) {
        this.computer.queueEvent(event, arguments);
    }

    public int getRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalRedstoneOutput(side);
    }

    public void setRedstoneInput(ComputerSide side, int level) {
        this.computer.getEnvironment().setRedstoneInput(side, level);
    }

    public int getBundledRedstoneOutput(ComputerSide side) {
        return this.computer.getEnvironment().getExternalBundledRedstoneOutput(side);
    }

    public void setBundledRedstoneInput(ComputerSide side, int combination) {
        this.computer.getEnvironment().setBundledRedstoneInput(side, combination);
    }

    public void addAPI(ILuaAPI api) {
        this.computer.addApi(api);
    }

    public void setPeripheral(ComputerSide side, IPeripheral peripheral) {
        this.computer.getEnvironment().setPeripheral(side, peripheral);
    }

    public IPeripheral getPeripheral(ComputerSide side) {
        return this.computer.getEnvironment().getPeripheral(side);
    }

    public void setLabel(String label) {
        this.computer.setLabel(label);
    }

    @Override
    public double getTimeOfDay() {
        return (double)((this.world.func_72820_D() + 6000L) % 24000L) / 1000.0;
    }

    @Override
    public int getDay() {
        return (int)((this.world.func_72820_D() + 6000L) / 24000L) + 1;
    }

    @Override
    public MetricsObserver getMetrics() {
        return this.metrics;
    }

    @Override
    public IWritableMount createRootMount() {
        return ComputerCraftAPI.createSaveDirMount((World)this.world, "computer/" + this.computer.getID(), ComputerCraft.computerSpaceLimit);
    }
}

