/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.blocks.BlockComputer;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.util.CapabilityUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileComputer
extends TileComputerBase {
    private ComputerProxy proxy;
    private LazyOptional<IPeripheral> peripheral;

    public TileComputer(ComputerFamily family, TileEntityType<? extends TileComputer> type) {
        super(type, family);
    }

    @Override
    protected ServerComputer createComputer(int id) {
        ComputerFamily family = this.getFamily();
        ServerComputer computer = new ServerComputer((ServerWorld)this.func_145831_w(), id, this.label, family, ComputerCraft.computerTermWidth, ComputerCraft.computerTermHeight);
        computer.setPosition(this.func_174877_v());
        return computer;
    }

    protected boolean isUsableByPlayer(PlayerEntity player) {
        return this.isUsable(player);
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)BlockComputer.FACING);
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
        BlockState existing = this.func_195044_w();
        if (existing.func_177229_b(BlockComputer.STATE) != newState) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), (BlockState)existing.func_206870_a(BlockComputer.STATE, (Comparable)((Object)newState)), 3);
        }
    }

    @Override
    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        if (localSide == ComputerSide.RIGHT) {
            return ComputerSide.LEFT;
        }
        if (localSide == ComputerSide.LEFT) {
            return ComputerSide.RIGHT;
        }
        return localSide;
    }

    @Nullable
    public Container createMenu(int id, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        return new ComputerMenuWithoutInventory((ContainerType<? extends ContainerComputerBase>)((ContainerType)Registry.ModContainers.COMPUTER.get()), id, inventory, this::isUsableByPlayer, this.createServerComputer(), this.getFamily());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheral == null) {
                this.peripheral = LazyOptional.of(() -> {
                    if (this.proxy == null) {
                        this.proxy = new ComputerProxy(() -> this);
                    }
                    return new ComputerPeripheral("computer", this.proxy);
                });
            }
            return this.peripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.peripheral = CapabilityUtil.invalidate(this.peripheral);
    }
}

