/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.DetailRegistry;
import dan200.computercraft.api.detail.IDetailProvider;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.api.media.IMediaProvider;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.impl.Services;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface ComputerCraftAPIService {
    public static ComputerCraftAPIService get() {
        ComputerCraftAPIService instance = Instance.INSTANCE;
        return instance == null ? Services.raise(ComputerCraftAPIService.class, Instance.ERROR) : instance;
    }

    @Nonnull
    public String getInstalledVersion();

    public int createUniqueNumberedSaveDir(@Nonnull World var1, @Nonnull String var2);

    @Nullable
    public IWritableMount createSaveDirMount(@Nonnull World var1, @Nonnull String var2, long var3);

    @Nullable
    public IMount createResourceMount(@Nonnull String var1, @Nonnull String var2);

    public void registerPeripheralProvider(@Nonnull IPeripheralProvider var1);

    public void registerGenericSource(@Nonnull GenericSource var1);

    public void registerGenericCapability(@Nonnull Capability<?> var1);

    public void registerTurtleUpgrade(@Nonnull ITurtleUpgrade var1);

    public void registerBundledRedstoneProvider(@Nonnull IBundledRedstoneProvider var1);

    public int getBundledRedstoneOutput(@Nonnull World var1, @Nonnull BlockPos var2, @Nonnull Direction var3);

    public void registerMediaProvider(@Nonnull IMediaProvider var1);

    public void registerPocketUpgrade(@Nonnull IPocketUpgrade var1);

    @Nonnull
    public IPacketNetwork getWirelessNetwork();

    public void registerAPIFactory(@Nonnull ILuaAPIFactory var1);

    @Deprecated
    public <T> void registerDetailProvider(@Nonnull Class<T> var1, @Nonnull IDetailProvider<T> var2);

    @Nonnull
    public IWiredNode createWiredNodeForElement(@Nonnull IWiredElement var1);

    @Nonnull
    public LazyOptional<IWiredElement> getWiredElementAt(@Nonnull IBlockReader var1, @Nonnull BlockPos var2, @Nonnull Direction var3);

    public DetailRegistry<ItemStack> getItemStackDetailRegistry();

    public DetailRegistry<BlockReference> getBlockInWorldDetailRegistry();

    public DetailRegistry<FluidStack> getFluidStackDetailRegistry();

    public static class Instance {
        @Nullable
        static final ComputerCraftAPIService INSTANCE;
        @Nullable
        static final Throwable ERROR;

        private Instance() {
        }

        static {
            Services.LoadedService<ComputerCraftAPIService> helper = Services.tryLoad(ComputerCraftAPIService.class);
            INSTANCE = helper.instance();
            ERROR = helper.error();
        }
    }
}

