/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonObject;
import dan200.computercraft.data.RecipeWrapper;
import dan200.computercraft.shared.ComputerCraftTags;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.recipe.ComputerUpgradeRecipe;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.turtle.recipes.TurtleRecipe;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.ImpostorShapelessRecipe;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Blocks;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class RecipeGenerator
extends RecipeProvider {
    public RecipeGenerator(DataGenerator generator) {
        super(generator);
    }

    protected void func_200404_a(@Nonnull Consumer<IFinishedRecipe> add) {
        this.basicRecipes(add);
        this.diskColours(add);
        this.pocketUpgrades(add);
        this.turtleUpgrades(add);
        RecipeGenerator.addSpecial(add, PrintoutRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, DiskRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, ColourableRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, TurtleUpgradeRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, PocketComputerUpgradeRecipe.SERIALIZER);
    }

    private void diskColours(@Nonnull Consumer<IFinishedRecipe> add) {
        for (Colour colour : Colour.VALUES) {
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)Registry.ModItems.DISK.get())).func_203221_a((ITag)Tags.Items.DUSTS_REDSTONE).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)DyeItem.func_195961_a((DyeColor)RecipeGenerator.ofColour(colour))).func_200490_a("computercraft:disk").func_200483_a("has_drive", (ICriterionInstance)RecipeGenerator.inventoryChange((IItemProvider)Registry.ModBlocks.DISK_DRIVE.get())).func_200485_a((Consumer)RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add).withResultTag(x -> x.func_74768_a("Color", colour.getHex())), new ResourceLocation("computercraft", "disk_" + (colour.ordinal() + 1)));
        }
    }

    private void turtleUpgrades(@Nonnull Consumer<IFinishedRecipe> add) {
        for (ComputerFamily family : ComputerFamily.values()) {
            ItemStack base = TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null);
            if (base.func_190926_b()) continue;
            String nameId = family.name().toLowerCase(Locale.ROOT);
            TurtleUpgrades.getVanillaUpgrades().forEach(upgrade -> {
                ItemStack result = TurtleItemFactory.create(-1, null, -1, family, null, upgrade, -1, null);
                ShapedRecipeBuilder.func_200470_a((IItemProvider)result.func_77973_b()).func_200473_b(String.format("%s:turtle_%s", "computercraft", nameId)).func_200472_a("#T").func_200462_a(Character.valueOf('T'), (IItemProvider)base.func_77973_b()).func_200462_a(Character.valueOf('#'), (IItemProvider)upgrade.getCraftingItem().func_77973_b()).func_200465_a("has_items", (ICriterionInstance)RecipeGenerator.inventoryChange(new IItemProvider[]{base.func_77973_b(), upgrade.getCraftingItem().func_77973_b()})).func_200467_a((Consumer)RecipeWrapper.wrap(ImpostorRecipe.SERIALIZER, add).withResultTag(result.func_77978_p()), new ResourceLocation("computercraft", String.format("turtle_%s/%s/%s", nameId, upgrade.getUpgradeID().func_110624_b(), upgrade.getUpgradeID().func_110623_a())));
            });
        }
    }

    private void pocketUpgrades(@Nonnull Consumer<IFinishedRecipe> add) {
        for (ComputerFamily family : ComputerFamily.values()) {
            ItemStack base = PocketComputerItemFactory.create(-1, null, -1, family, null);
            if (base.func_190926_b()) continue;
            String nameId = family.name().toLowerCase(Locale.ROOT);
            PocketUpgrades.getVanillaUpgrades().forEach(upgrade -> {
                ItemStack result = PocketComputerItemFactory.create(-1, null, -1, family, upgrade);
                ShapedRecipeBuilder.func_200470_a((IItemProvider)result.func_77973_b()).func_200473_b(String.format("%s:pocket_%s", "computercraft", nameId)).func_200472_a("#").func_200472_a("P").func_200462_a(Character.valueOf('P'), (IItemProvider)base.func_77973_b()).func_200462_a(Character.valueOf('#'), (IItemProvider)upgrade.getCraftingItem().func_77973_b()).func_200465_a("has_items", (ICriterionInstance)RecipeGenerator.inventoryChange(new IItemProvider[]{base.func_77973_b(), upgrade.getCraftingItem().func_77973_b()})).func_200467_a((Consumer)RecipeWrapper.wrap(ImpostorRecipe.SERIALIZER, add).withResultTag(result.func_77978_p()), new ResourceLocation("computercraft", String.format("pocket_%s/%s/%s", nameId, upgrade.getUpgradeID().func_110624_b(), upgrade.getUpgradeID().func_110623_a())));
            });
        }
    }

    private void basicRecipes(@Nonnull Consumer<IFinishedRecipe> add) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)Registry.ModItems.CABLE.get()), (int)6).func_200472_a(" # ").func_200472_a("#R#").func_200472_a(" # ").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200465_a("has_modem", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.COMPUTER_NORMAL.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("#G#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_redstone", (ICriterionInstance)RecipeGenerator.inventoryChange((ITag<Item>)Tags.Items.DUSTS_REDSTONE)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.COMPUTER_ADVANCED.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("#G#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_components", (ICriterionInstance)RecipeGenerator.inventoryChange(new IItemProvider[]{Items.field_151137_ax, Items.field_151043_k})).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModItems.COMPUTER_ADVANCED.get())).func_200472_a("###").func_200472_a("#C#").func_200472_a("# #").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('C'), (IItemProvider)Registry.ModItems.COMPUTER_NORMAL.get()).func_200465_a("has_components", (ICriterionInstance)RecipeGenerator.inventoryChange(RecipeGenerator.itemPredicate((IItemProvider)Registry.ModItems.COMPUTER_NORMAL.get()), RecipeGenerator.itemPredicate((ITag<Item>)Tags.Items.INGOTS_GOLD))).func_200467_a((Consumer)RecipeWrapper.wrap(ComputerUpgradeRecipe.SERIALIZER, add).withExtraData(RecipeGenerator.family(ComputerFamily.ADVANCED)), new ResourceLocation("computercraft", "computer_advanced_upgrade"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.COMPUTER_COMMAND.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("#G#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('R'), (IItemProvider)Blocks.field_150483_bI).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_components", (ICriterionInstance)RecipeGenerator.inventoryChange(new IItemProvider[]{Blocks.field_150483_bI})).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.TURTLE_NORMAL.get())).func_200472_a("###").func_200472_a("#C#").func_200472_a("#I#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('C'), (IItemProvider)Registry.ModItems.COMPUTER_NORMAL.get()).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.CHESTS_WOODEN).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange((IItemProvider)Registry.ModItems.COMPUTER_NORMAL.get())).func_200464_a((Consumer)RecipeWrapper.wrap(TurtleRecipe.SERIALIZER, add).withExtraData(RecipeGenerator.family(ComputerFamily.NORMAL)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.TURTLE_ADVANCED.get())).func_200472_a("###").func_200472_a("#C#").func_200472_a("#I#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('C'), (IItemProvider)Registry.ModItems.COMPUTER_ADVANCED.get()).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.CHESTS_WOODEN).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange((IItemProvider)Registry.ModItems.COMPUTER_NORMAL.get())).func_200464_a((Consumer)RecipeWrapper.wrap(TurtleRecipe.SERIALIZER, add).withExtraData(RecipeGenerator.family(ComputerFamily.ADVANCED)));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.TURTLE_ADVANCED.get())).func_200472_a("###").func_200472_a("#C#").func_200472_a(" B ").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('C'), (IItemProvider)Registry.ModItems.TURTLE_NORMAL.get()).func_200469_a(Character.valueOf('B'), (ITag)Tags.Items.STORAGE_BLOCKS_GOLD).func_200465_a("has_components", (ICriterionInstance)RecipeGenerator.inventoryChange(RecipeGenerator.itemPredicate((IItemProvider)Registry.ModItems.TURTLE_NORMAL.get()), RecipeGenerator.itemPredicate((ITag<Item>)Tags.Items.INGOTS_GOLD))).func_200467_a((Consumer)RecipeWrapper.wrap(ComputerUpgradeRecipe.SERIALIZER, add).withExtraData(RecipeGenerator.family(ComputerFamily.ADVANCED)), new ResourceLocation("computercraft", "turtle_advanced_upgrade"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.DISK_DRIVE.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("#R#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.MONITOR_NORMAL.get())).func_200472_a("###").func_200472_a("#G#").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)Registry.ModBlocks.MONITOR_ADVANCED.get()), (int)4).func_200472_a("###").func_200472_a("#G#").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModItems.POCKET_COMPUTER_NORMAL.get())).func_200472_a("###").func_200472_a("#A#").func_200472_a("#G#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_151153_ao).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200465_a("has_apple", (ICriterionInstance)RecipeGenerator.inventoryChange(new IItemProvider[]{Items.field_151153_ao})).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get())).func_200472_a("###").func_200472_a("#A#").func_200472_a("#G#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_151153_ao).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200465_a("has_apple", (ICriterionInstance)RecipeGenerator.inventoryChange(new IItemProvider[]{Items.field_151153_ao})).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get())).func_200472_a("###").func_200472_a("#C#").func_200472_a("# #").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('C'), (IItemProvider)Registry.ModItems.POCKET_COMPUTER_NORMAL.get()).func_200465_a("has_components", (ICriterionInstance)RecipeGenerator.inventoryChange(RecipeGenerator.itemPredicate((IItemProvider)Registry.ModItems.POCKET_COMPUTER_NORMAL.get()), RecipeGenerator.itemPredicate((ITag<Item>)Tags.Items.INGOTS_GOLD))).func_200467_a((Consumer)RecipeWrapper.wrap(ComputerUpgradeRecipe.SERIALIZER, add).withExtraData(RecipeGenerator.family(ComputerFamily.ADVANCED)), new ResourceLocation("computercraft", "pocket_computer_advanced_upgrade"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.PRINTER.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("#D#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('D'), (ITag)Tags.Items.DYES).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.SPEAKER.get())).func_200472_a("###").func_200472_a("#N#").func_200472_a("#R#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200462_a(Character.valueOf('N'), (IItemProvider)Blocks.field_196586_al).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModItems.WIRED_MODEM.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200465_a("has_cable", (ICriterionInstance)RecipeGenerator.inventoryChange((IItemProvider)Registry.ModItems.CABLE.get())).func_200464_a(add);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)Registry.ModBlocks.WIRED_MODEM_FULL.get())).func_200487_b((IItemProvider)Registry.ModItems.WIRED_MODEM.get()).func_200483_a("has_modem", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).func_200485_a(add, new ResourceLocation("computercraft", "wired_modem_full_from"));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)Registry.ModItems.WIRED_MODEM.get())).func_200487_b((IItemProvider)Registry.ModBlocks.WIRED_MODEM_FULL.get()).func_200483_a("has_modem", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).func_200485_a(add, new ResourceLocation("computercraft", "wired_modem_full_to"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.WIRELESS_MODEM_NORMAL.get())).func_200472_a("###").func_200472_a("#E#").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('E'), (ITag)Tags.Items.ENDER_PEARLS).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.WIRELESS_MODEM_ADVANCED.get())).func_200472_a("###").func_200472_a("#E#").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151061_bv).func_200465_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).func_200465_a("has_wireless", (ICriterionInstance)RecipeGenerator.inventoryChange((IItemProvider)Registry.ModBlocks.WIRELESS_MODEM_NORMAL.get())).func_200464_a(add);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196184_dx).func_203221_a((ITag)Tags.Items.HEADS).func_200487_b((IItemProvider)Registry.ModItems.MONITOR_NORMAL.get()).func_200483_a("has_monitor", (ICriterionInstance)RecipeGenerator.inventoryChange((IItemProvider)Registry.ModItems.MONITOR_NORMAL.get())).func_200485_a((Consumer)RecipeWrapper.wrap(IRecipeSerializer.field_222158_b, add).withResultTag(RecipeGenerator.playerHead("Cloudhunter", "6d074736-b1e9-4378-a99b-bd8777821c9c")), new ResourceLocation("computercraft", "skull_cloudy"));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196184_dx).func_203221_a((ITag)Tags.Items.HEADS).func_200487_b((IItemProvider)Registry.ModItems.COMPUTER_ADVANCED.get()).func_200483_a("has_computer", (ICriterionInstance)RecipeGenerator.inventoryChange((IItemProvider)Registry.ModItems.COMPUTER_ADVANCED.get())).func_200485_a((Consumer)RecipeWrapper.wrap(IRecipeSerializer.field_222158_b, add).withResultTag(RecipeGenerator.playerHead("dan200", "f3c8d69b-0776-4512-8434-d1b2165909eb")), new ResourceLocation("computercraft", "skull_dan200"));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)Registry.ModItems.PRINTED_PAGES.get())).func_200491_b((IItemProvider)Registry.ModItems.PRINTED_PAGE.get(), 2).func_203221_a((ITag)Tags.Items.STRING).func_200483_a("has_printer", (ICriterionInstance)RecipeGenerator.inventoryChange((IItemProvider)Registry.ModBlocks.PRINTER.get())).func_200482_a((Consumer)RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)Registry.ModItems.PRINTED_BOOK.get())).func_203221_a((ITag)Tags.Items.LEATHER).func_200491_b((IItemProvider)Registry.ModItems.PRINTED_PAGE.get(), 1).func_203221_a((ITag)Tags.Items.STRING).func_200483_a("has_printer", (ICriterionInstance)RecipeGenerator.inventoryChange((IItemProvider)Registry.ModBlocks.PRINTER.get())).func_200482_a((Consumer)RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add));
    }

    private static DyeColor ofColour(Colour colour) {
        return DyeColor.func_196056_a((int)(15 - colour.ordinal()));
    }

    private static InventoryChangeTrigger.Instance inventoryChange(ITag<Item> stack) {
        return InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{RecipeGenerator.itemPredicate(stack)});
    }

    private static InventoryChangeTrigger.Instance inventoryChange(IItemProvider ... stack) {
        return InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])stack);
    }

    private static InventoryChangeTrigger.Instance inventoryChange(ItemPredicate ... items) {
        return InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])items);
    }

    private static ItemPredicate itemPredicate(IItemProvider item) {
        return ItemPredicate.Builder.func_200309_a().func_200308_a(item).func_200310_b();
    }

    private static ItemPredicate itemPredicate(ITag<Item> item) {
        return ItemPredicate.Builder.func_200309_a().func_200307_a(item).func_200310_b();
    }

    private static CompoundNBT playerHead(String name, String uuid) {
        CompoundNBT owner = new CompoundNBT();
        owner.func_74778_a("Name", name);
        owner.func_74778_a("Id", uuid);
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("SkullOwner", (INBT)owner);
        return tag;
    }

    private static Consumer<JsonObject> family(ComputerFamily family) {
        return json -> json.addProperty("family", family.toString());
    }

    private static void addSpecial(Consumer<IFinishedRecipe> add, SpecialRecipeSerializer<?> special) {
        CustomRecipeBuilder.func_218656_a(special).func_200499_a(add, special.getRegistryName().toString());
    }
}

