/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.function.VarArgFunction;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.asm.LuaMethod;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.VarargArguments;

class BasicFunction
extends VarArgFunction {
    private final CobaltLuaMachine machine;
    private final LuaMethod method;
    private final Object instance;
    private final ILuaContext context;
    private final String name;

    BasicFunction(CobaltLuaMachine machine, LuaMethod method, Object instance, ILuaContext context, String name) {
        this.machine = machine;
        this.method = method;
        this.instance = instance;
        this.context = context;
        this.name = name;
    }

    @Override
    public Varargs invoke(LuaState luaState, Varargs args) throws LuaError {
        MethodResult results;
        try (VarargArguments arguments = VarargArguments.of(args);){
            results = this.method.apply(this.instance, this.context, arguments);
        }
        if (results.getCallback() != null) {
            throw new IllegalStateException("Cannot have a yielding non-yielding function");
        }
        return this.machine.toValues(results.getResult());
    }

    public static LuaError wrap(LuaException exception) {
        return exception.hasLevel() ? new LuaError(exception.getMessage()) : new LuaError(exception.getMessage(), exception.getLevel());
    }
}

