/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.options;

import com.google.common.net.InetAddresses;
import dan200.computercraft.core.apis.http.options.AddressPredicate;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.core.apis.http.options.PartialOptions;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.OptionalInt;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AddressRule {
    public static final long MAX_DOWNLOAD = 0x1000000L;
    public static final long MAX_UPLOAD = 0x400000L;
    public static final int TIMEOUT = 30000;
    public static final int WEBSOCKET_MESSAGE = 131072;
    private final AddressPredicate predicate;
    private final OptionalInt port;
    private final PartialOptions partial;

    private AddressRule(@Nonnull AddressPredicate predicate, OptionalInt port, @Nonnull PartialOptions partial) {
        this.predicate = predicate;
        this.partial = partial;
        this.port = port;
    }

    @Nullable
    public static AddressRule parse(String filter, OptionalInt port, @Nonnull PartialOptions partial) {
        int cidr = filter.indexOf(47);
        if (cidr >= 0) {
            String prefixSizeStr;
            String addressStr = filter.substring(0, cidr);
            AddressPredicate.HostRange range = AddressPredicate.HostRange.parse(addressStr, prefixSizeStr = filter.substring(cidr + 1));
            return range == null ? null : new AddressRule(range, port, partial);
        }
        if (filter.equalsIgnoreCase("$private")) {
            return new AddressRule(AddressPredicate.PrivatePattern.INSTANCE, port, partial);
        }
        Pattern pattern = Pattern.compile("^\\Q" + filter.replaceAll("\\*", "\\\\E.*\\\\Q") + "\\E$", 2);
        return new AddressRule(new AddressPredicate.DomainPattern(pattern), port, partial);
    }

    private boolean matches(String domain, int port, InetAddress address, Inet4Address ipv4Address) {
        if (this.port.isPresent() && this.port.getAsInt() != port) {
            return false;
        }
        return this.predicate.matches(domain) || this.predicate.matches(address) || ipv4Address != null && this.predicate.matches(ipv4Address);
    }

    public static Options apply(Iterable<? extends AddressRule> rules, String domain, InetSocketAddress socketAddress) {
        PartialOptions options = PartialOptions.DEFAULT;
        int port = socketAddress.getPort();
        InetAddress address = socketAddress.getAddress();
        Inet4Address ipv4Address = address instanceof Inet6Address && InetAddresses.is6to4Address((Inet6Address)((Inet6Address)address)) ? InetAddresses.get6to4IPv4Address((Inet6Address)((Inet6Address)address)) : null;
        for (AddressRule addressRule : rules) {
            if (!addressRule.matches(domain, port, address, ipv4Address)) continue;
            options = options.merge(addressRule.partial);
        }
        return options.toOptions();
    }
}

