/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import dan200.computercraft.core.apis.http.options.Action;
import dan200.computercraft.core.apis.http.options.AddressRule;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.shared.util.ThreadUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import java.io.ByteArrayInputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;

public final class NetworkUtils {
    public static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(4, ThreadUtils.builder("Network").setPriority(3).build());
    public static final EventLoopGroup LOOP_GROUP = new NioEventLoopGroup(4, ThreadUtils.builder("Netty").setPriority(3).build());
    public static final AbstractTrafficShapingHandler SHAPING_HANDLER = new GlobalTrafficShapingHandler((ScheduledExecutorService)EXECUTOR, (long)ComputerCraft.httpUploadBandwidth, (long)ComputerCraft.httpDownloadBandwidth);
    private static final Object sslLock;
    private static TrustManagerFactory trustManager;
    private static SslContext sslContext;
    private static boolean triedSslContext;
    private static final String letsEncryptRootCert = "-----BEGIN CERTIFICATE-----\nMIIFazCCA1OgAwIBAgIRAIIQz7DSQONZRGPgu2OCiwAwDQYJKoZIhvcNAQELBQAw\nTzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2Vh\ncmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMTUwNjA0MTEwNDM4\nWhcNMzUwNjA0MTEwNDM4WjBPMQswCQYDVQQGEwJVUzEpMCcGA1UEChMgSW50ZXJu\nZXQgU2VjdXJpdHkgUmVzZWFyY2ggR3JvdXAxFTATBgNVBAMTDElTUkcgUm9vdCBY\nMTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK3oJHP0FDfzm54rVygc\nh77ct984kIxuPOZXoHj3dcKi/vVqbvYATyjb3miGbESTtrFj/RQSa78f0uoxmyF+\n0TM8ukj13Xnfs7j/EvEhmkvBioZxaUpmZmyPfjxwv60pIgbz5MDmgK7iS4+3mX6U\nA5/TR5d8mUgjU+g4rk8Kb4Mu0UlXjIB0ttov0DiNewNwIRt18jA8+o+u3dpjq+sW\nT8KOEUt+zwvo/7V3LvSye0rgTBIlDHCNAymg4VMk7BPZ7hm/ELNKjD+Jo2FR3qyH\nB5T0Y3HsLuJvW5iB4YlcNHlsdu87kGJ55tukmi8mxdAQ4Q7e2RCOFvu396j3x+UC\nB5iPNgiV5+I3lg02dZ77DnKxHZu8A/lJBdiB3QW0KtZB6awBdpUKD9jf1b0SHzUv\nKBds0pjBqAlkd25HN7rOrFleaJ1/ctaJxQZBKT5ZPt0m9STJEadao0xAH0ahmbWn\nOlFuhjuefXKnEgV4We0+UXgVCwOPjdAvBbI+e0ocS3MFEvzG6uBQE3xDk3SzynTn\njh8BCNAw1FtxNrQHusEwMFxIt4I7mKZ9YIqioymCzLq9gwQbooMDQaHWBfEbwrbw\nqHyGO0aoSCqI3Haadr8faqU9GY/rOPNk3sgrDQoo//fb4hVC1CLQJ13hef4Y53CI\nrU7m2Ys6xt0nUW7/vGT1M0NPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNV\nHRMBAf8EBTADAQH/MB0GA1UdDgQWBBR5tFnme7bl5AFzgAiIyBpY9umbbjANBgkq\nhkiG9w0BAQsFAAOCAgEAVR9YqbyyqFDQDLHYGmkgJykIrGF1XIpu+ILlaS/V9lZL\nubhzEFnTIZd+50xx+7LSYK05qAvqFyFWhfFQDlnrzuBZ6brJFe+GnY+EgPbk6ZGQ\n3BebYhtF8GaV0nxvwuo77x/Py9auJ/GpsMiu/X1+mvoiBOv/2X/qkSsisRcOj/KK\nNFtY2PwByVS5uCbMiogziUwthDyC3+6WVwW6LLv3xLfHTjuCvjHIInNzktHCgKQ5\nORAzI4JMPJ+GslWYHb4phowim57iaztXOoJwTdwJx4nLCgdNbOhdjsnvzqvHu7Ur\nTkXWStAmzOVyyghqpZXjFaH3pO3JLF+l+/+sKAIuvtd7u+Nxe5AW0wdeRlN8NwdC\njNPElpzVmbUq4JUagEiuTDkHzsxHpFKVK7q4+63SM1N95R1NbdWhscdCb+ZAJzVc\noyi3B43njTOQ5yOf+1CceWxG1bQVs5ZufpsMljq4Ui0/1lvh+wjChP4kqKOJ2qxq\n4RgqsahDYVvTH9w7jXbyLeiNdd8XM2w9U/t7y0Ff/9yi0GE44Za4rF2LN9d11TPA\nmRGunUHBcnWEvgJBQl9nJEiU0Zsnvgc/ubhPgXRR4Xq37Z0j4r7g1SgEEzwxA57d\nemyPxgcYxn/eR44/KJ4EBs+lVDR3veyJm+kXQ99b21/+jh5Xos1AnX5iItreGCc=\n-----END CERTIFICATE-----\n";

    private NetworkUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrustManagerFactory getTrustManager() {
        if (trustManager != null) {
            return trustManager;
        }
        Object object = sslLock;
        synchronized (object) {
            if (trustManager != null) {
                return trustManager;
            }
            TrustManagerFactory tmf = null;
            try {
                String version = System.getProperty("java.version");
                if (version.regionMatches(0, "1.8.0_", 0, 6) && version.length() == 8) {
                    Certificate ca = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(letsEncryptRootCert.getBytes()));
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    ks.load(null, null);
                    ks.setCertificateEntry(Integer.toString(1), ca);
                    TrustManagerFactory additional = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    additional.init(ks);
                    X509TrustManager x509tm = null;
                    for (TrustManager tm : additional.getTrustManagers()) {
                        if (!(tm instanceof X509TrustManager)) continue;
                        x509tm = (X509TrustManager)tm;
                        break;
                    }
                    tmf = new MergedTrustManagerFactory(TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm()), x509tm);
                } else {
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                }
                tmf.init((KeyStore)null);
            }
            catch (Exception e) {
                ComputerCraft.log.error("Cannot setup trust manager", (Throwable)e);
            }
            trustManager = tmf;
            return trustManager;
        }
    }

    public static SslContext getSslContext() throws HTTPRequestException {
        if (sslContext != null || triedSslContext) {
            return sslContext;
        }
        Object object = sslLock;
        synchronized (object) {
            if (sslContext != null || triedSslContext) {
                return sslContext;
            }
            try {
                sslContext = SslContextBuilder.forClient().trustManager(NetworkUtils.getTrustManager()).build();
                return sslContext;
            }
            catch (SSLException e) {
                ComputerCraft.log.error("Cannot construct SSL context", (Throwable)e);
                triedSslContext = true;
                sslContext = null;
                throw new HTTPRequestException("Cannot create a secure connection");
            }
        }
    }

    public static void reloadConfig() {
        SHAPING_HANDLER.configure((long)ComputerCraft.httpUploadBandwidth, (long)ComputerCraft.httpDownloadBandwidth);
    }

    public static void reset() {
        SHAPING_HANDLER.trafficCounter().resetCumulativeTime();
    }

    public static InetSocketAddress getAddress(URI uri, boolean ssl) throws HTTPRequestException {
        return NetworkUtils.getAddress(uri.getHost(), uri.getPort(), ssl);
    }

    public static InetSocketAddress getAddress(String host, int port, boolean ssl) throws HTTPRequestException {
        InetSocketAddress socketAddress;
        if (port < 0) {
            int n = port = ssl ? 443 : 80;
        }
        if ((socketAddress = new InetSocketAddress(host, port)).isUnresolved()) {
            throw new HTTPRequestException("Unknown host");
        }
        return socketAddress;
    }

    public static Options getOptions(String host, InetSocketAddress address) throws HTTPRequestException {
        Options options = AddressRule.apply(ComputerCraft.httpRules, host, address);
        if (options.action == Action.DENY) {
            throw new HTTPRequestException("Domain not permitted");
        }
        return options;
    }

    public static byte[] toBytes(ByteBuf buffer) {
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        return bytes;
    }

    @Nonnull
    public static String toFriendlyError(@Nonnull Throwable cause) {
        if (cause instanceof WebSocketHandshakeException || cause instanceof HTTPRequestException) {
            return cause.getMessage();
        }
        if (cause instanceof TooLongFrameException) {
            return "Message is too large";
        }
        if (cause instanceof ReadTimeoutException || cause instanceof ConnectTimeoutException) {
            return "Timed out";
        }
        if (cause instanceof SSLHandshakeException || cause instanceof DecoderException && cause.getCause() instanceof SSLHandshakeException) {
            return "Could not create a secure connection";
        }
        return "Could not connect";
    }

    static {
        EXECUTOR.setKeepAliveTime(60L, TimeUnit.SECONDS);
        sslLock = new Object();
        triedSslContext = false;
    }

    private static class MergedTrustManagerFactory
    extends TrustManagerFactory {
        MergedTrustManagerFactory(TrustManagerFactory b, X509TrustManager a) {
            super(new Spi(b, a), b.getProvider(), b.getAlgorithm());
        }

        private static class Spi
        extends TrustManagerFactorySpi {
            private final TrustManagerFactory base;
            private final X509TrustManager additional;

            Spi(TrustManagerFactory b, X509TrustManager a) {
                this.base = b;
                this.additional = a;
            }

            @Override
            protected void engineInit(KeyStore keyStore) throws KeyStoreException {
                this.base.init(keyStore);
            }

            @Override
            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
                this.base.init(managerFactoryParameters);
            }

            @Override
            protected TrustManager[] engineGetTrustManagers() {
                TrustManager[] managers = this.base.getTrustManagers();
                for (int i = 0; i < managers.length; ++i) {
                    if (!(managers[i] instanceof X509TrustManager)) continue;
                    managers[i] = new MergedX509TrustManager((X509TrustManager)managers[i], this.additional);
                }
                return managers;
            }
        }
    }

    private static class MergedX509TrustManager
    implements X509TrustManager {
        private final X509TrustManager base;
        private final X509TrustManager additional;

        MergedX509TrustManager(X509TrustManager b, X509TrustManager a) {
            this.base = b;
            this.additional = a;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.base.getAcceptedIssuers();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.base.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                this.additional.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.base.checkClientTrusted(chain, authType);
        }
    }
}

