/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.apis.handles.HandleGeneric;
import dan200.computercraft.core.filesystem.TrackingCloseable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Optional;

public class BinaryReadableHandle
extends HandleGeneric {
    private static final int BUFFER_SIZE = 8192;
    private final ReadableByteChannel reader;
    final SeekableByteChannel seekable;
    private final ByteBuffer single = ByteBuffer.allocate(1);

    BinaryReadableHandle(ReadableByteChannel reader, SeekableByteChannel seekable, TrackingCloseable closeable) {
        super(closeable);
        this.reader = reader;
        this.seekable = seekable;
    }

    public static BinaryReadableHandle of(ReadableByteChannel channel, TrackingCloseable closeable) {
        SeekableByteChannel seekable = BinaryReadableHandle.asSeekable(channel);
        return seekable == null ? new BinaryReadableHandle(channel, null, closeable) : new Seekable(seekable, closeable);
    }

    public static BinaryReadableHandle of(ReadableByteChannel channel) {
        return BinaryReadableHandle.of(channel, new TrackingCloseable.Impl(channel));
    }

    @LuaFunction
    public final Object[] read(Optional<Integer> countArg) throws LuaException {
        this.checkOpen();
        try {
            Object[] objectArray;
            if (countArg.isPresent()) {
                int totalRead;
                int count = countArg.get();
                if (count < 0) {
                    throw new LuaException("Cannot read a negative number of bytes");
                }
                if (count == 0 && this.seekable != null) {
                    Object[] objectArray2;
                    if (this.seekable.position() >= this.seekable.size()) {
                        objectArray2 = null;
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray2 = objectArray3;
                        objectArray3[0] = "";
                    }
                    return objectArray2;
                }
                if (count <= 8192) {
                    ByteBuffer buffer = ByteBuffer.allocate(count);
                    int read = this.reader.read(buffer);
                    if (read < 0) {
                        return null;
                    }
                    buffer.flip();
                    return new Object[]{buffer};
                }
                ByteBuffer buffer = ByteBuffer.allocate(8192);
                int read = this.reader.read(buffer);
                if (read < 0) {
                    return null;
                }
                if (read >= count || read < 8192) {
                    buffer.flip();
                    return new Object[]{buffer};
                }
                ArrayList<ByteBuffer> parts = new ArrayList<ByteBuffer>(4);
                parts.add(buffer);
                for (totalRead = read; read >= 8192 && totalRead < count && (read = this.reader.read(buffer = ByteBuffer.allocate(Math.min(8192, count - totalRead)))) >= 0; totalRead += read) {
                    parts.add(buffer);
                }
                byte[] bytes = new byte[totalRead];
                int pos = 0;
                for (ByteBuffer part : parts) {
                    System.arraycopy(part.array(), 0, bytes, pos, part.position());
                    pos += part.position();
                }
                return new Object[]{bytes};
            }
            this.single.clear();
            int b = this.reader.read(this.single);
            if (b == -1) {
                objectArray = null;
            } else {
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = this.single.get(0) & 0xFF;
            }
            return objectArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    @LuaFunction
    public final Object[] readAll() throws LuaException {
        this.checkOpen();
        try {
            Object[] objectArray;
            int expected = 32;
            if (this.seekable != null) {
                expected = Math.max(expected, (int)(this.seekable.size() - this.seekable.position()));
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream(expected);
            ByteBuffer buf = ByteBuffer.allocate(8192);
            boolean readAnything = false;
            while (true) {
                buf.clear();
                int r = this.reader.read(buf);
                if (r == -1) break;
                readAnything = true;
                stream.write(buf.array(), 0, r);
            }
            if (readAnything) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = stream.toByteArray();
            } else {
                objectArray = null;
            }
            return objectArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    @LuaFunction
    public final Object[] readLine(Optional<Boolean> withTrailingArg) throws LuaException {
        this.checkOpen();
        boolean withTrailing = withTrailingArg.orElse(false);
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            boolean readAnything = false;
            boolean readRc = false;
            while (true) {
                this.single.clear();
                int read = this.reader.read(this.single);
                if (read <= 0) {
                    Object[] objectArray;
                    if (readRc) {
                        stream.write(13);
                    }
                    if (readAnything) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = stream.toByteArray();
                    } else {
                        objectArray = null;
                    }
                    return objectArray;
                }
                readAnything = true;
                byte chr = this.single.get(0);
                if (chr == 10) {
                    if (withTrailing) {
                        if (readRc) {
                            stream.write(13);
                        }
                        stream.write(chr);
                    }
                    return new Object[]{stream.toByteArray()};
                }
                if (readRc) {
                    stream.write(13);
                }
                if (readRc = chr == 13) continue;
                stream.write(chr);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class Seekable
    extends BinaryReadableHandle {
        Seekable(SeekableByteChannel seekable, TrackingCloseable closeable) {
            super(seekable, seekable, closeable);
        }

        @LuaFunction
        public final Object[] seek(Optional<String> whence, Optional<Long> offset) throws LuaException {
            this.checkOpen();
            return Seekable.handleSeek(this.seekable, whence, offset);
        }
    }
}

