/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib.doubles;

import cc.tweaked.internal.cobalt.lib.doubles.Assert;
import cc.tweaked.internal.cobalt.lib.doubles.DecimalRepBuf;
import cc.tweaked.internal.cobalt.lib.doubles.DiyFp;
import cc.tweaked.internal.cobalt.lib.doubles.Ieee;
import cc.tweaked.internal.cobalt.lib.doubles.PowersOfTenCache;
import cc.tweaked.internal.cobalt.lib.doubles.UnsignedValues;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.value.qual.UnknownVal;

public class FastDtoa {
    private static final @UnknownVal @Signed int ASCII_ZERO = 48;
    public static final @UnknownVal @Signed int FAST_DTOA_MAXIMAL_LENGTH = 17;
    private static final @UnknownVal @Signed int MINIMAL_TARGET_EXPONENT = -60;
    private static final @UnknownVal @Signed int MAXIMAL_TARGET_EXPONENT = -32;
    private static final @Unsigned @UnknownVal int @UnknownVal @Signed [] SMALL_POWERS_OF_TEN = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    private static @UnknownVal @Signed boolean roundWeedCounted(@UnknownVal @Signed DecimalRepBuf buf, @Unsigned @UnknownVal long rest, @Unsigned @UnknownVal long tenKappa, @Unsigned @UnknownVal long unit, @UnknownVal @Signed int @UnknownVal @Signed [] kappa) {
        if (Assert.assertEnabled()) {
            Assert.assertThat(UnsignedValues.ulongLT(rest, tenKappa));
        }
        if (UnsignedValues.ulongGE(unit, tenKappa)) {
            return false;
        }
        if (UnsignedValues.ulongLE(tenKappa - unit, unit)) {
            return false;
        }
        if (UnsignedValues.ulongGT(tenKappa - rest, rest) && UnsignedValues.ulongGE(tenKappa - 2L * rest, 2L * unit)) {
            return true;
        }
        if (UnsignedValues.ulongGT(rest, unit) && UnsignedValues.ulongLE(tenKappa - (rest - unit), rest - unit)) {
            kappa[0] = kappa[0] + buf.incrementLast();
            return true;
        }
        return false;
    }

    static void biggestPowerTen(@Unsigned @UnknownVal int number, @UnknownVal @Signed int numberBits, @Unsigned @UnknownVal int @UnknownVal @Signed [] power, @UnknownVal @Signed int @UnknownVal @Signed [] exponentPlusOne) {
        Assert.requireArg(UnsignedValues.uintLT(number, 1 << numberBits + 1), "number must fit in numberBits");
        int exponentPlusOneGuess = (numberBits + 1) * 1233 >> 12;
        int pow = SMALL_POWERS_OF_TEN[++exponentPlusOneGuess];
        if (UnsignedValues.uintLT(number, pow)) {
            pow = SMALL_POWERS_OF_TEN[--exponentPlusOneGuess];
        }
        power[0] = pow;
        exponentPlusOne[0] = exponentPlusOneGuess;
    }

    private static @UnknownVal @Signed boolean digitGenCounted(@UnknownVal @Signed DiyFp w, @UnknownVal @Signed int requestedDigits, @UnknownVal @Signed DecimalRepBuf buf, @UnknownVal @Signed int @UnknownVal @Signed [] kappa) {
        int divisorExponentPlusOne;
        if (Assert.assertEnabled()) {
            Assert.assertThat(-60 <= w.e() && w.e() <= -32);
        }
        if (Assert.assertEnabled()) {
            Assert.assertThat(true);
        }
        if (Assert.assertEnabled()) {
            Assert.assertThat(true);
        }
        long wError = 1L;
        DiyFp one = new DiyFp(1L << -w.e(), w.e());
        @Unsigned int integrals = UnsignedValues.toUint(w.f() >>> -one.e());
        long fractionals = w.f() & one.f() - 1L;
        int[] inDivisorExponentPlusOne = new int[1];
        @Unsigned int[] inDivisor = new int[1];
        FastDtoa.biggestPowerTen(integrals, 64 - -one.e(), inDivisor, inDivisorExponentPlusOne);
        int divisor = inDivisor[0];
        kappa[0] = divisorExponentPlusOne = inDivisorExponentPlusOne[0];
        buf.clearBuf();
        while (kappa[0] > 0) {
            buf.append(UnsignedValues.uDivide(integrals, divisor));
            integrals = UnsignedValues.uRemainder(integrals, divisor);
            kappa[0] = kappa[0] - 1;
            if (--requestedDigits == 0) break;
            divisor = UnsignedValues.uDivide(divisor, 10);
        }
        if (requestedDigits == 0) {
            long rest = (UnsignedValues.toUlong(integrals) << -one.e()) + fractionals;
            return FastDtoa.roundWeedCounted(buf, rest, UnsignedValues.toUlong(divisor) << -one.e(), wError, kappa);
        }
        if (Assert.assertEnabled()) {
            Assert.assertThat(one.e() >= -60);
            Assert.assertThat(UnsignedValues.ulongLT(fractionals, one.f()));
            Assert.assertThat(UnsignedValues.ulongGE(UnsignedValues.uDivide(-1L, 10L), one.f()));
        }
        while (requestedDigits > 0 && UnsignedValues.ulongGT(fractionals, wError)) {
            wError *= 10L;
            buf.append((fractionals *= 10L) >>> -one.e());
            --requestedDigits;
            fractionals &= one.f() - 1L;
            kappa[0] = kappa[0] - 1;
        }
        if (requestedDigits != 0) {
            return false;
        }
        return FastDtoa.roundWeedCounted(buf, fractionals, one.f(), wError, kappa);
    }

    private static @UnknownVal @Signed boolean grisu3Counted(@UnknownVal @Signed double v, @UnknownVal @Signed int requestedDigits, @UnknownVal @Signed DecimalRepBuf buf, @UnknownVal @Signed int @UnknownVal @Signed [] decimalExponent) {
        DiyFp w = new Ieee.Double(v).asNormalizedDiyFp();
        DiyFp[] inTenMk = new DiyFp[1];
        int[] inMk = new int[1];
        int tenMkMinimalBinaryExponent = -60 - (w.e() + 64);
        int tenMkMaximalBinaryExponent = -32 - (w.e() + 64);
        PowersOfTenCache.getCachedPowerForBinaryExponentRange(tenMkMinimalBinaryExponent, tenMkMaximalBinaryExponent, inTenMk, inMk);
        DiyFp ten_mk = inTenMk[0];
        int mk = inMk[0];
        if (Assert.assertEnabled()) {
            Assert.assertThat(-60 <= w.e() + ten_mk.e() + 64 && -32 >= w.e() + ten_mk.e() + 64);
        }
        DiyFp scaledW = DiyFp.times(w, ten_mk);
        int[] inKappa = new int[1];
        boolean result = FastDtoa.digitGenCounted(scaledW, requestedDigits, buf, inKappa);
        decimalExponent[0] = -mk + inKappa[0];
        return result;
    }

    public static @UnknownVal @Signed boolean fastDtoa(@UnknownVal @Signed double v, @UnknownVal @Signed int requestedDigits, @UnknownVal @Signed DecimalRepBuf buf) {
        int[] decimalExponent;
        boolean result;
        if (Assert.assertEnabled()) {
            Assert.assertThat(v > 0.0);
            Assert.assertThat(!new Ieee.Double(v).isSpecial());
        }
        if (result = FastDtoa.grisu3Counted(v, requestedDigits, buf, decimalExponent = new int[1])) {
            buf.setPointPosition(buf.length() + decimalExponent[0]);
        } else {
            buf.reset();
        }
        return result;
    }
}

