/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.server.radar.tracker;

import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class SyncedTrackedPlayer {
    private final UUID id;
    private double x;
    private double y;
    private double z;
    private ResourceLocation dimension;

    public SyncedTrackedPlayer(UUID id, double x, double y, double z, ResourceLocation dimension) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public SyncedTrackedPlayer setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public SyncedTrackedPlayer setDimension(ResourceLocation dimension) {
        this.dimension = dimension;
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public boolean matchesEnough(PlayerEntity player, double maxAxisDistance) {
        return Math.abs(player.func_226277_ct_() - this.x) <= maxAxisDistance && Math.abs(player.func_226278_cu_() - this.y) <= maxAxisDistance && Math.abs(player.func_226281_cx_() - this.z) <= maxAxisDistance && player.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)this.dimension);
    }

    public void update(PlayerEntity player) {
        this.setPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()).setDimension(player.field_70170_p.func_234923_W_().func_240901_a_());
    }

    public void copyFrom(SyncedTrackedPlayer trackedPlayer) {
        this.setPos(trackedPlayer.getX(), trackedPlayer.getY(), trackedPlayer.getZ()).setDimension(trackedPlayer.getDimension());
    }
}

