/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.icon.XaeroIcon;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;

public class EntityIconManager {
    public static final XaeroIcon FAILED = new XaeroIcon(null, 0, 0);
    public static final XaeroIcon DOT = new XaeroIcon(null, 0, 0);
    private EntityIconPrerenderer prerenderer;
    private final IXaeroMinimap modMain;
    private Map<ResourceLocation, EntityIconDefinition> iconDefinitions;
    private Map<String, XaeroIcon> cachedTextures;
    private boolean canPrerender;
    private Gson gson;
    private StringBuilder entityStringBuilder;
    private EntityIconModelConfig defaultModelConfig;

    public EntityIconManager(IXaeroMinimap modMain, EntityIconPrerenderer prerenderer) {
        this.modMain = modMain;
        this.prerenderer = prerenderer;
        this.iconDefinitions = new HashMap<ResourceLocation, EntityIconDefinition>();
        this.cachedTextures = new HashMap<String, XaeroIcon>();
        this.gson = new Gson();
        this.resetResources();
        this.entityStringBuilder = new StringBuilder();
        this.defaultModelConfig = new EntityIconModelConfig();
    }

    public <T extends Entity> XaeroIcon getEntityHeadTexture(T entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean debug, boolean debugEntityVariantIds) {
        String cacheKey;
        XaeroIcon cachedValue;
        EquipmentSlotType relevantArmourSlot;
        LivingEntity livingEntity;
        ItemStack armorItemStack;
        ResourceLocation entityId = EntityType.func_200718_a((EntityType)entity.func_200600_R());
        EntityIconDefinition iconDefinition = this.iconDefinitions.get(entityId);
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        EntityRenderer entityRenderer = renderManager.func_78713_a(entity);
        StringBuilder entityStringBuilder = this.entityStringBuilder;
        entityStringBuilder.setLength(0);
        boolean variantIdAppended = false;
        if (iconDefinition != null) {
            Method variantIdBuilderMethod = iconDefinition.getVariantIdBuilderMethod();
            if (variantIdBuilderMethod != null) {
                try {
                    variantIdBuilderMethod.invoke(null, entityStringBuilder, entityRenderer, entity);
                    variantIdAppended = true;
                }
                catch (Exception e) {
                    MinimapLogs.LOGGER.error("Exception while using the variant builder ID method " + iconDefinition.getVariantIdBuilderMethodString() + " defined for " + entityId, (Throwable)e);
                    iconDefinition.setVariantIdBuilderMethod(null);
                }
            } else {
                Method variantOldIdMethod = iconDefinition.getOldVariantIdMethod();
                if (variantOldIdMethod != null) {
                    try {
                        String entityVariantString = (String)variantOldIdMethod.invoke(null, entityRenderer, entity);
                        entityStringBuilder.append(entityVariantString);
                        variantIdAppended = true;
                    }
                    catch (Exception e) {
                        MinimapLogs.LOGGER.error("Exception while using the variant ID method " + iconDefinition.getOldVariantIdMethodString() + " defined for " + entityId, (Throwable)e);
                        iconDefinition.setOldVariantIdMethod(null);
                    }
                }
            }
        }
        if (!variantIdAppended) {
            EntityIconDefinitions.buildVariantIdString(entityStringBuilder, entityRenderer, entity);
        }
        while (GL11.glGetError() != 0) {
        }
        String entityVariantString = entityStringBuilder.toString();
        entityStringBuilder.append("%").append(entity.func_70022_Q());
        if (entity instanceof LivingEntity && !(entity instanceof PlayerEntity) && (armorItemStack = livingEntity.func_184582_a(relevantArmourSlot = (livingEntity = (LivingEntity)entity) instanceof HorseEntity ? EquipmentSlotType.CHEST : EquipmentSlotType.HEAD)) != null && armorItemStack != ItemStack.field_190927_a) {
            entityStringBuilder.append("%").append(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)armorItemStack.func_77973_b()));
        }
        if ((cachedValue = this.cachedTextures.get(cacheKey = entityStringBuilder.toString())) == null) {
            ResourceLocation iconType;
            if (debugEntityVariantIds) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent(entityVariantString));
            }
            String variantMapKey = entityVariantString;
            if (iconDefinition != null) {
                iconType = iconDefinition.getVariantType(variantMapKey);
                if (iconType == null) {
                    variantMapKey = "default";
                    iconType = iconDefinition.getVariantType(variantMapKey);
                }
            } else {
                iconType = EntityIconDefinition.MODEL_TYPE;
            }
            if (iconType == EntityIconDefinition.MODEL_TYPE) {
                if (this.canPrerender) {
                    EntityIconModelConfig variantModelConfig;
                    EntityIconModelConfig modelConfig = this.defaultModelConfig;
                    EntityIconModelConfig entityIconModelConfig = variantModelConfig = iconDefinition == null ? null : iconDefinition.getModelConfig(variantMapKey);
                    if (variantModelConfig != null) {
                        modelConfig = variantModelConfig;
                    }
                    cachedValue = this.prerenderer.prerender(cacheKey, entityRenderer, entity, defaultFramebuffer, helper, scale, modelConfig, this.defaultModelConfig, null, true, false, debug);
                    this.cachedTextures.put(cacheKey, cachedValue);
                    this.canPrerender = false;
                } else {
                    cachedValue = null;
                }
            } else if (iconType == EntityIconDefinition.DOT_TYPE) {
                cachedValue = DOT;
                this.cachedTextures.put(cacheKey, cachedValue);
            } else if (this.canPrerender) {
                ResourceLocation sprite = iconDefinition.getSprite(variantMapKey);
                boolean isOutlined = iconType == EntityIconDefinition.OUTLINED_SPRITE;
                boolean isFlipped = !isOutlined && iconType != EntityIconDefinition.NORMAL_SPRITE;
                cachedValue = this.prerenderer.prerender(cacheKey, entityRenderer, entity, defaultFramebuffer, helper, scale, null, this.defaultModelConfig, sprite, isOutlined, isFlipped, debug);
                this.cachedTextures.put(cacheKey, cachedValue);
                this.canPrerender = false;
            } else {
                cachedValue = null;
            }
        }
        return cachedValue;
    }

    public void reset() {
        this.prerenderer.clearAtlases();
        this.cachedTextures.clear();
        MinimapLogs.LOGGER.info("Entity icon manager reset!");
    }

    public void resetResources() {
        MinimapLogs.LOGGER.info("Reloading entity icon resources...");
        Set entityIds = ForgeRegistries.ENTITIES.getKeys();
        Gson gson = this.gson;
        int attempts = 5;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.resetResourcesAttempt(gson, entityIds);
                break;
            }
            catch (IOException ioe) {
                if (i != attempts - 1) continue;
                throw new RuntimeException(ioe);
            }
        }
        MinimapLogs.LOGGER.info("Done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetResourcesAttempt(Gson gson, Set<ResourceLocation> entityIds) throws IOException {
        this.iconDefinitions.clear();
        for (ResourceLocation id : entityIds) {
            InputStream resourceInput = null;
            BufferedReader reader = null;
            String entityDefinitionJson = null;
            IResource resource = null;
            try {
                resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("xaerominimap", "entity/icon/definition/" + id.func_110624_b() + "/" + id.func_110623_a() + ".json"));
            }
            catch (FileNotFoundException fnfe) {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                if (resource == null) continue;
                resourceInput = resource.func_199027_b();
                reader = new BufferedReader(new InputStreamReader(resourceInput));
                StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(line -> {
                    stringBuilder.append((String)line);
                    stringBuilder.append('\n');
                });
                entityDefinitionJson = stringBuilder.toString();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                EntityIconDefinition entityIconDefinition = (EntityIconDefinition)gson.fromJson(entityDefinitionJson, EntityIconDefinition.class);
                entityIconDefinition.onConstruct(id);
                this.iconDefinitions.put(id, entityIconDefinition);
            }
            catch (JsonSyntaxException jse) {
                MinimapLogs.LOGGER.error("Json syntax exception when loading the entity icon definition for " + id + ".", (Throwable)jse);
            }
        }
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }

    public void onModelRenderDetection(EntityModel<?> model, IVertexBuilder vertexConsumer, float red, float green, float blue, float alpha) {
        this.prerenderer.onModelRenderDetection(model, vertexConsumer, red, green, blue, alpha);
    }

    public void onModelPartRenderDetection(ModelRenderer modelRenderer, float red, float green, float blue, float alpha) {
        this.prerenderer.onModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }
}

