/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.category.rule;

import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.LightType;
import xaero.common.category.rule.ObjectCategoryHardRule;
import xaero.common.minimap.radar.RadarUtils;
import xaero.common.minimap.radar.category.EntityRadarCategoryConstants;

public final class EntityRadarCategoryHardRules {
    public static final List<ObjectCategoryHardRule<Entity, PlayerEntity>> HARD_RULES_LIST = EntityRadarCategoryConstants.LIST_FACTORY.get();
    public static final Map<String, ObjectCategoryHardRule<Entity, PlayerEntity>> HARD_RULES = EntityRadarCategoryConstants.MAP_FACTORY.get();
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_NOTHING = new ObjectCategoryHardRule.Builder().setName("nothing").setPredicate((e, p) -> false).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_ANYTHING = new ObjectCategoryHardRule.Builder().setName("anything").setPredicate((e, p) -> true).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_LIVING = new ObjectCategoryHardRule.Builder().setName("living").setPredicate((e, p) -> e instanceof LivingEntity).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_PLAYER = new ObjectCategoryHardRule.Builder().setName("players").setPredicate((e, p) -> e instanceof PlayerEntity).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_SAME_TEAM = new ObjectCategoryHardRule.Builder().setName("same-team").setPredicate((e, p) -> p.func_96124_cp() == e.func_96124_cp()).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_HOSTILE = new ObjectCategoryHardRule.Builder().setName("hostile").setPredicate((e, p) -> RadarUtils.isHostile(e)).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_TAMED = new ObjectCategoryHardRule.Builder().setName("tamed").setPredicate((e, p) -> RadarUtils.isTamed(e, p)).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_ITEM = new ObjectCategoryHardRule.Builder().setName("items").setPredicate((e, p) -> e instanceof ItemEntity).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_FRIENDLY = new ObjectCategoryHardRule.Builder().setName("friendly").setPredicate((e, p) -> !IS_HOSTILE.isFollowedBy((Entity)e, (PlayerEntity)p)).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_OTHER_TEAMS = new ObjectCategoryHardRule.Builder().setName("other-teams").setPredicate((e, p) -> !IS_SAME_TEAM.isFollowedBy((Entity)e, (PlayerEntity)p)).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_BABY = new ObjectCategoryHardRule.Builder().setName("baby").setPredicate((e, p) -> e instanceof LivingEntity && ((LivingEntity)e).func_70631_g_()).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_VANILLA = new ObjectCategoryHardRule.Builder().setName("vanilla").setPredicate((e, p) -> {
        EntityType type = e.func_200600_R();
        ResourceLocation resourceLocation = type == null ? null : EntityType.func_200718_a((EntityType)type);
        return resourceLocation == null ? false : resourceLocation.func_110624_b().equals("minecraft");
    }).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_MODDED = new ObjectCategoryHardRule.Builder().setName("modded").setPredicate((e, p) -> !IS_VANILLA.isFollowedBy((Entity)e, (PlayerEntity)p)).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_ABOVE_GROUND = new ObjectCategoryHardRule.Builder().setName("above-ground").setPredicate((e, p) -> e.field_70170_p.func_226658_a_(LightType.SKY, e.func_233580_cy_()) == 15).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_BELOW_GROUND = new ObjectCategoryHardRule.Builder().setName("below-ground").setPredicate((e, p) -> !IS_ABOVE_GROUND.isFollowedBy((Entity)e, (PlayerEntity)p)).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_LIT = new ObjectCategoryHardRule.Builder().setName("block-lit").setPredicate((e, p) -> e.field_70170_p.func_226658_a_(LightType.BLOCK, e.func_233580_cy_()) > 0).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_UNLIT = new ObjectCategoryHardRule.Builder().setName("block-unlit").setPredicate((e, p) -> !IS_LIT.isFollowedBy((Entity)e, (PlayerEntity)p)).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> HAS_CUSTOM_NAME = new ObjectCategoryHardRule.Builder().setName("has-custom-name").setPredicate((e, p) -> e.func_145818_k_()).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> NO_CUSTOM_NAME = new ObjectCategoryHardRule.Builder().setName("no-custom-name").setPredicate((e, p) -> !HAS_CUSTOM_NAME.isFollowedBy((Entity)e, (PlayerEntity)p)).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_IN_TEAM = new ObjectCategoryHardRule.Builder().setName("in-a-team").setPredicate((e, p) -> e.func_96124_cp() != null).build(HARD_RULES, HARD_RULES_LIST);
    public static final ObjectCategoryHardRule<Entity, PlayerEntity> IS_TEAMLESS = new ObjectCategoryHardRule.Builder().setName("teamless").setPredicate((e, p) -> !IS_IN_TEAM.isFollowedBy((Entity)e, (PlayerEntity)p)).build(HARD_RULES, HARD_RULES_LIST);
}

