/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import java.nio.file.Path;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.config.CommonConfig;
import xaero.common.message.basic.ClientboundRulesPacket;
import xaero.common.message.basic.HandshakePacket;
import xaero.common.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.common.server.MinecraftServerData;
import xaero.common.server.MineraftServerDataInitializer;
import xaero.common.server.level.LevelMapProperties;
import xaero.common.server.level.LevelMapPropertiesIO;
import xaero.common.server.player.IServerPlayer;
import xaero.common.server.player.ServerPlayerData;

public class ForgeCommonEventHandler {
    private final IXaeroMinimap modMain;

    public ForgeCommonEventHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public void register() {
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity oldPlayer = event.getOriginal();
        if (oldPlayer instanceof ServerPlayerEntity) {
            PlayerEntity newPlayer = event.getPlayer();
            ((IServerPlayer)newPlayer).setXaeroMinimapPlayerData(ServerPlayerData.get((ServerPlayerEntity)oldPlayer));
        }
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        new MineraftServerDataInitializer().init(event.getServer(), this.modMain);
    }

    @SubscribeEvent
    public void onServerStopped(FMLServerStoppedEvent event) {
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            this.modMain.getMessageHandler().sendToPlayer((ServerPlayerEntity)player, new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(ServerPlayerEntity player) {
        this.modMain.getMessageHandler().sendToPlayer(player, new HandshakePacket());
        CommonConfig config = this.modMain.getCommonConfig();
        this.modMain.getMessageHandler().sendToPlayer(player, new ClientboundRulesPacket(config.allowCaveModeOnServer, config.allowNetherCaveModeOnServer, config.allowRadarOnServer));
        Path propertiesPath = player.field_70170_p.func_73046_m().func_240776_a_(LevelMapPropertiesIO.FILE_NAME);
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.func_184102_h());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            this.modMain.getMessageHandler().sendToPlayer(player, properties);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("suppressed exception", t);
            player.field_71135_a.func_194028_b((ITextComponent)new TranslationTextComponent("gui.xaero_error_loading_properties"));
        }
    }
}

