/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import net.minecraft.client.Minecraft;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.waypoints.WaypointsManager;

public class FMLEventHandler {
    private IXaeroMinimap modMain;

    public FMLEventHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        XaeroMinimapSession minimapSession;
        if (event.phase == TickEvent.Phase.START && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            MinimapProcessor minimap = minimapSession.getMinimapProcessor();
            minimap.onClientTick();
            if (Minecraft.func_71410_x().field_71462_r == null) {
                minimapSession.getKeyEventHandler().onKeyInput(Minecraft.func_71410_x(), this.modMain, minimapSession);
            }
        }
    }

    @SubscribeEvent
    public void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.player == Minecraft.func_71410_x().field_71439_g) {
            try {
                XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
                if (minimapSession != null && event.phase == TickEvent.Phase.START) {
                    MinimapProcessor minimap = minimapSession.getMinimapProcessor();
                    WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
                    waypointsManager.updateWorldIds();
                    minimap.onPlayerTick();
                    waypointsManager.updateWaypoints();
                    Minecraft mc = Minecraft.func_71410_x();
                    minimapSession.getKeyEventHandler().handleEvents(mc, minimapSession);
                    this.playerTickPostOverridable(minimapSession);
                }
            }
            catch (Throwable t) {
                this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(t);
            }
        }
    }

    protected void playerTickPostOverridable(XaeroMinimapSession minimapSession) {
    }

    @SubscribeEvent
    public void handleRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null) {
            this.modMain.getInterfaces().getMinimapInterface().checkCrashes();
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                MinimapProcessor minimap = minimapSession.getMinimapProcessor();
                minimap.getMinimapWriter().onRender();
            }
        }
    }
}

